/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftEnum;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftEnumNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        String name = null;
        Demangled namespace = null;
        Demangled privateDeclNamespace = null;
        block5: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block5;
                }
                case PrivateDeclName: {
                    Demangled temp = child.demangle(demangler);
                    name = temp.getName();
                    privateDeclNamespace = temp.getNamespace();
                    continue block5;
                }
                case Class: 
                case Enum: 
                case Extension: 
                case Module: 
                case Structure: {
                    namespace = child.demangle(demangler);
                    continue block5;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        return new SwiftEnum(this.properties.mangled(), this.properties.originalDemangled(), name, SwiftNode.join(namespace, privateDeclNamespace), demangler);
    }
}

