/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.apport;

public class MemoryInfo {
    public static final String NAME = "MINIDUMP_MEMORY_INFO";
    private long baseAddress;
    private long regionSize;
    private String permissions;
    private long rva;
    private String description;
    private String text;

    MemoryInfo(String text) {
        this.text = text;
        this.parse();
    }

    private void parse() {
        String[] split = this.text.trim().split("\\s+");
        String range = split[0];
        String[] rangeSplit = range.split("-");
        long start = Long.parseUnsignedLong(rangeSplit[0], 16);
        long stop = Long.parseUnsignedLong(rangeSplit[1], 16);
        this.baseAddress = start;
        this.regionSize = stop - start;
        this.setPermissions(split[1]);
        long offset = Long.parseUnsignedLong(split[2], 16);
        this.setRva(offset);
        if (split.length > 5) {
            this.setDescription(split[5]);
        }
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(long baseAddress) {
        this.baseAddress = baseAddress;
    }

    public long getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(long regionSize) {
        this.regionSize = regionSize;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getRva() {
        return this.rva;
    }

    public void setRva(long rva) {
        this.rva = rva;
    }
}

