/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class MipsDisassembleCommand
extends DisassembleCommand {
    private boolean mips16Mode;

    public MipsDisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean mips16Mode) {
        super(startSet, restrictedSet, true);
        this.mips16Mode = mips16Mode;
    }

    public MipsDisassembleCommand(Address start, AddressSetView restrictedSet, boolean mips16Mode) {
        super(start, restrictedSet, true);
        this.mips16Mode = mips16Mode;
    }

    public String getName() {
        return "Disassemble " + (this.mips16Mode ? "Mips16" : "Mips");
    }

    @Override
    public void setSeedContext(DisassemblerContextImpl seedContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialContext(RegisterValue initialContextValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean applyTo(Program program, TaskMonitor monitor) {
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        Register m16modeReg = program.getProgramContext().getRegister("ISA_MODE");
        if (m16modeReg == null) {
            if (this.mips16Mode) {
                this.setStatusMsg("MIPS16 mode not supported");
                return false;
            }
            return super.applyTo(program, monitor);
        }
        RegisterValue m16modeValue = new RegisterValue(m16modeReg, BigInteger.valueOf(this.mips16Mode ? 1L : 0L));
        super.setInitialContext(m16modeValue);
        int alignment = this.mips16Mode ? 2 : 4;
        long alignMask = this.mips16Mode ? -2L : -4L;
        try {
            if (this.startSet != null) {
                AddressSet alignedSet = new AddressSet();
                for (AddressRange range : this.startSet) {
                    Address max;
                    long maxOffset;
                    Address min = range.getMinAddress();
                    long minOfffset = min.getOffset() & alignMask;
                    if (minOfffset != min.getOffset()) {
                        min = min.getNewAddress(minOfffset);
                    }
                    if ((maxOffset = (max = range.getMaxAddress()).getOffset() & alignMask) < minOfffset) continue;
                    if (maxOffset != max.getOffset()) {
                        max = max.getNewAddress(maxOffset);
                    }
                    alignedSet.addRange(min, max);
                }
                if (alignedSet.isEmpty()) {
                    this.unalignedStart = true;
                    return false;
                }
                this.startSet = program.getListing().getUndefinedRanges((AddressSetView)alignedSet, true, monitor);
                if (this.startSet.isEmpty()) {
                    return true;
                }
            }
        }
        catch (CancelledException e) {
            return true;
        }
        return this.doDisassembly(monitor, program, alignment);
    }
}

