/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFStringAttribute;
import ghidra.util.Msg;
import java.io.IOException;

public class DWARFDeferredStringAttribute
extends DWARFStringAttribute {
    private long offset;

    public DWARFDeferredStringAttribute(long offset, DWARFAttributeDef<?> def) {
        super(null, def);
        this.offset = offset;
    }

    @Override
    public String getValue(DWARFCompilationUnit cu) {
        if (this.value == null) {
            try {
                this.value = cu.getProgram().getString(this.getAttributeForm(), this.offset, cu);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"error getting string value", (Throwable)e);
                return null;
            }
        }
        return this.value;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public String toString(DWARFCompilationUnit cu) {
        String str = this.value == null && cu != null ? this.getValue(cu) : this.value;
        str = str != null ? "\"%s\"".formatted(this.value) : "-missing-";
        return "%s : %s = %s (offset 0x%x)".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), str, this.offset});
    }

    @Override
    public String toString() {
        return this.toString(null);
    }
}

