/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util.string;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.util.string.FoundString;
import ghidra.program.util.string.FoundStringCallback;
import ghidra.util.ascii.ByteStreamCharMatcher;
import ghidra.util.ascii.CharSetRecognizer;
import ghidra.util.ascii.CharWidth;
import ghidra.util.ascii.MultiByteCharMatcher;
import ghidra.util.ascii.Sequence;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStringSearcher {
    private Program program;
    private List<ByteStreamCharMatcher> matchers;
    private int alignment;

    protected AbstractStringSearcher(Program program, CharSetRecognizer charSet, int minimumStringSize, int alignment, boolean includeUTF8, boolean includeUTF16, boolean includeUTF32) {
        this.program = program;
        this.alignment = alignment;
        Endian endian = program.getLanguage().isBigEndian() ? Endian.BIG : Endian.LITTLE;
        this.matchers = new ArrayList<ByteStreamCharMatcher>();
        if (includeUTF8) {
            this.matchers.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF8, endian, alignment, 0));
        }
        if (includeUTF16) {
            this.addUTF16Matchers(this.matchers, charSet, endian, minimumStringSize);
        }
        if (includeUTF32) {
            this.addUTF32Matchers(this.matchers, charSet, endian, minimumStringSize);
        }
    }

    private void addUTF16Matchers(List<ByteStreamCharMatcher> matchersList, CharSetRecognizer charSet, Endian endian, int minimumStringSize) {
        matchersList.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF16, endian, this.getAlignment(), 0));
        if (this.getAlignment() == 1) {
            matchersList.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF16, endian, this.getAlignment(), 1));
        }
    }

    private void addUTF32Matchers(List<ByteStreamCharMatcher> matchersList, CharSetRecognizer charSet, Endian endian, int minimumStringSize) {
        this.matchers.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF32, endian, this.getAlignment(), 0));
        if (this.getAlignment() == 2 || this.getAlignment() == 1) {
            this.matchers.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF32, endian, this.getAlignment(), 2));
        }
        if (this.getAlignment() == 1) {
            this.matchers.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF32, endian, this.getAlignment(), 1));
            this.matchers.add(new MultiByteCharMatcher(minimumStringSize, charSet, CharWidth.UTF32, endian, this.getAlignment(), 3));
        }
    }

    public AddressSetView search(AddressSetView addressSet, FoundStringCallback callback, boolean searchLoadedMemoryBlocksOnly, TaskMonitor monitor) {
        addressSet = addressSet == null ? this.program.getMemory() : addressSet;
        AddressSetView updatedAddressSet = this.updateAddressesToSearch(addressSet, searchLoadedMemoryBlocksOnly);
        AddressRangeIterator addressRanges = updatedAddressSet.getAddressRanges();
        monitor.initialize(addressSet.getNumAddresses());
        while (addressRanges.hasNext()) {
            if (monitor.isCancelled()) {
                return updatedAddressSet;
            }
            AddressRange range = (AddressRange)addressRanges.next();
            this.searchRange(range, callback, monitor);
        }
        return updatedAddressSet;
    }

    public AddressSetView updateAddressesToSearch(AddressSetView addressSet, boolean useLoadedBlocksOnly) {
        AddressSet updatedAddressSet = useLoadedBlocksOnly ? addressSet.intersect(this.program.getMemory().getLoadedAndInitializedAddressSet()) : addressSet.intersect(this.program.getMemory().getAllInitializedAddressSet());
        return updatedAddressSet;
    }

    private void searchRange(AddressRange range, FoundStringCallback callback, TaskMonitor monitor) {
        this.matchers.forEach(m -> m.reset());
        range = this.adjustRangeForAlignment(range);
        MemoryBufferImpl buf = new MemoryBufferImpl(this.program.getMemory(), range.getMinAddress());
        long length = range.getLength();
        int i = 0;
        while ((long)i < length) {
            if (monitor.isCancelled()) {
                return;
            }
            if (i % 1000 == 999) {
                monitor.incrementProgress(1000L);
            }
            byte b = this.getByte((MemBuffer)buf, i);
            for (ByteStreamCharMatcher matcher : this.matchers) {
                if (!matcher.add(b)) continue;
                this.processSequence(callback, matcher.getSequence(), (MemBuffer)buf);
            }
            ++i;
        }
        for (ByteStreamCharMatcher matcher : this.matchers) {
            if (!matcher.endSequence()) continue;
            this.processSequence(callback, matcher.getSequence(), (MemBuffer)buf);
        }
    }

    private AddressRange adjustRangeForAlignment(AddressRange range) {
        if (this.getAlignment() == 1) {
            return range;
        }
        long offset = range.getMinAddress().getOffset();
        long mod = offset % (long)this.getAlignment();
        if (mod == 0L) {
            return range;
        }
        Address newStart = range.getMinAddress().getNewAddress(offset + (long)this.getAlignment() - mod);
        return new AddressRangeImpl(newStart, range.getMaxAddress());
    }

    private byte getByte(MemBuffer buf, int i) {
        try {
            return buf.getByte(i);
        }
        catch (MemoryAccessException e) {
            return -1;
        }
    }

    protected abstract void processSequence(FoundStringCallback var1, Sequence var2, MemBuffer var3);

    protected FoundString getFoundString(MemBuffer buf, Sequence sequence, DataType stringDataType) {
        Address address = buf.getAddress().add(sequence.getStart());
        return new FoundString(address, sequence.getLength(), stringDataType);
    }

    public int getAlignment() {
        return this.alignment;
    }
}

