/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.protorules.DatatypeFilter;
import ghidra.program.model.lang.protorules.PrimitiveExtractor;
import ghidra.program.model.lang.protorules.SizeRestrictedFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.Map;

public class HomogeneousAggregate
extends SizeRestrictedFilter {
    public static final String NAME_FLOAT = "homogeneous-float-aggregate";
    public static final int DEFAULT_MAX_PRIMITIVES = 4;
    private String name;
    private int metaType;
    private int maxPrimitives;

    public HomogeneousAggregate(String nm, int meta) {
        this.name = nm;
        this.metaType = meta;
        this.maxPrimitives = 4;
    }

    public HomogeneousAggregate(String nm, int meta, int maxPrim, int minSize, int maxSize) {
        super(minSize, maxSize);
        this.name = nm;
        this.metaType = meta;
        this.maxPrimitives = maxPrim;
    }

    public HomogeneousAggregate(HomogeneousAggregate op2) {
        super(op2);
        this.name = op2.name;
        this.metaType = op2.metaType;
        this.maxPrimitives = op2.maxPrimitives;
    }

    @Override
    public DatatypeFilter clone() {
        return new HomogeneousAggregate(this);
    }

    @Override
    public boolean filter(DataType dt) {
        int meta = PcodeDataTypeManager.getMetatype(dt);
        if (meta != 4 && meta != 3) {
            return false;
        }
        PrimitiveExtractor primitives = new PrimitiveExtractor(dt, true, 0, this.maxPrimitives);
        if (!primitives.isValid() || primitives.size() == 0 || primitives.containsUnknown() || !primitives.isAligned() || primitives.containsHoles()) {
            return false;
        }
        DataType base = primitives.get((int)0).dt;
        int baseMeta = PcodeDataTypeManager.getMetatype(base);
        if (baseMeta != this.metaType) {
            return false;
        }
        for (int i = 1; i < primitives.size(); ++i) {
            if (primitives.get((int)i).dt == base) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void encodeAttributes(Encoder encoder) throws IOException {
        super.encodeAttributes(encoder);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_MAX_PRIMITIVES, this.maxPrimitives);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_DATATYPE);
        encoder.writeString(AttributeId.ATTRIB_NAME, this.name);
        this.encodeAttributes(encoder);
        encoder.closeElement(ElementId.ELEM_DATATYPE);
    }

    @Override
    protected void restoreAttributesXml(XmlElement el) throws XmlParseException {
        super.restoreAttributesXml(el);
        for (Map.Entry attrib : el.getAttributes().entrySet()) {
            int xmlMaxPrim;
            String nm = (String)attrib.getKey();
            if (!nm.equals(AttributeId.ATTRIB_MAX_PRIMITIVES.name()) || (xmlMaxPrim = SpecXmlUtils.decodeInt((String)((String)attrib.getValue()))) <= 0) continue;
            this.maxPrimitives = xmlMaxPrim;
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_DATATYPE.name()});
        this.restoreAttributesXml(elem);
        parser.end(elem);
    }
}

