/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import java.io.IOException;

public class EquateSymbol
extends HighSymbol {
    public static final int FORMAT_DEFAULT = 0;
    public static final int FORMAT_HEX = 1;
    public static final int FORMAT_DEC = 2;
    public static final int FORMAT_OCT = 3;
    public static final int FORMAT_BIN = 4;
    public static final int FORMAT_CHAR = 5;
    public static final int FORMAT_FLOAT = 6;
    public static final int FORMAT_DOUBLE = 7;
    private long value;
    private int convert;

    public EquateSymbol(HighFunction func) {
        super(func);
    }

    public EquateSymbol(long uniqueId, String nm, long val, HighFunction func, Address addr, long hash) {
        super(uniqueId, nm, DataType.DEFAULT, func);
        this.category = 1;
        this.value = val;
        this.convert = 0;
        DynamicEntry entry = new DynamicEntry(this, addr, hash);
        this.addMapEntry(entry);
    }

    public EquateSymbol(long uniqueId, int conv, long val, HighFunction func, Address addr, long hash) {
        super(uniqueId, "", DataType.DEFAULT, func);
        this.category = 1;
        this.value = val;
        this.convert = conv;
        DynamicEntry entry = new DynamicEntry(this, addr, hash);
        this.addMapEntry(entry);
    }

    public long getValue() {
        return this.value;
    }

    public int getConvert() {
        return this.convert;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int attribId;
        int symel = decoder.openElement(ElementId.ELEM_EQUATESYMBOL);
        this.decodeHeader(decoder);
        this.type = DataType.DEFAULT;
        this.convert = 0;
        decoder.rewindAttributes();
        String formString = null;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_FORMAT.id()) continue;
            formString = decoder.readString();
        }
        if (formString != null) {
            if (formString.equals("hex")) {
                this.convert = 1;
            } else if (formString.equals("dec")) {
                this.convert = 2;
            } else if (formString.equals("char")) {
                this.convert = 5;
            } else if (formString.equals("oct")) {
                this.convert = 3;
            } else if (formString.equals("bin")) {
                this.convert = 4;
            } else if (formString.equals("float")) {
                this.convert = 6;
            } else if (formString.equals("double")) {
                this.convert = 7;
            }
        }
        int valel = decoder.openElement(ElementId.ELEM_VALUE);
        this.value = decoder.readUnsignedInteger(AttributeId.ATTRIB_CONTENT);
        decoder.closeElement(valel);
        decoder.closeElement(symel);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_EQUATESYMBOL);
        this.encodeHeader(encoder);
        if (this.convert != 0) {
            String formString = "hex";
            if (this.convert != 1) {
                if (this.convert == 2) {
                    formString = "dec";
                } else if (this.convert == 3) {
                    formString = "oct";
                } else if (this.convert == 4) {
                    formString = "bin";
                } else if (this.convert == 5) {
                    formString = "char";
                } else if (this.convert == 6) {
                    formString = "float";
                } else if (this.convert == 7) {
                    formString = "double";
                }
            }
            encoder.writeString(AttributeId.ATTRIB_FORMAT, formString);
        }
        encoder.openElement(ElementId.ELEM_VALUE);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_CONTENT, this.value);
        encoder.closeElement(ElementId.ELEM_VALUE);
        encoder.closeElement(ElementId.ELEM_EQUATESYMBOL);
    }

    public static int convertName(String nm, long val) {
        char firstChar;
        int pos = 0;
        if ((firstChar = nm.charAt(pos++)) == '-') {
            if (nm.length() > pos) {
                firstChar = nm.charAt(pos++);
            } else {
                return 0;
            }
        }
        switch (firstChar) {
            case '\"': 
            case '\'': {
                return 5;
            }
            case '0': {
                if (nm.length() >= pos + 1 && nm.charAt(pos) == 'x') {
                    return 1;
                }
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                if (nm.length() >= 3 && nm.charAt(2) == 'h') {
                    char secondChar = nm.charAt(1);
                    if (secondChar >= '0' && secondChar <= '9') {
                        return 5;
                    }
                    if (secondChar >= 'A' && secondChar <= 'F') {
                        return 5;
                    }
                }
                return 0;
            }
            default: {
                return 0;
            }
        }
        switch (nm.charAt(nm.length() - 1)) {
            case 'b': {
                return 4;
            }
            case 'o': {
                return 3;
            }
            case '\"': 
            case '\'': 
            case 'h': {
                return 5;
            }
        }
        return 2;
    }
}

