/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.printing;

import docking.util.GraphicsUtils;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.internal.EmptyLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.printing.PrintOptionsDialog;
import ghidra.util.DateUtils;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

public class CodeUnitPrintable
implements Printable {
    private LayoutModel lm;
    private int startIndex;
    private int endIndex;
    private List<Layout> layouts;
    private double scaleAmount;
    private TaskMonitor monitor;
    private PrintOptionsDialog pod;
    private Book book;
    private PrinterJob job;
    private Date startDate;
    private static final PaintContext PAINT_CONTEXT = new PaintContext();

    public CodeUnitPrintable(LayoutModel lm, int startIndex, int endIndex, double scaleAmount, TaskMonitor monitor, PrintOptionsDialog pod, Book book, PrinterJob job, Date startDate) {
        this.lm = lm;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.scaleAmount = scaleAmount;
        this.monitor = monitor;
        this.pod = pod;
        this.book = book;
        this.job = job;
        this.startDate = startDate;
    }

    public CodeUnitPrintable(LayoutModel lm, List<Layout> layouts, double scaleAmount, TaskMonitor monitor, PrintOptionsDialog pod, Book book, PrinterJob job, Date startDate) {
        this.lm = lm;
        this.layouts = layouts;
        this.scaleAmount = scaleAmount;
        this.monitor = monitor;
        this.pod = pod;
        this.book = book;
        this.job = job;
        this.startDate = startDate;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = GraphicsUtils.getGraphics2D((Graphics)graphics);
        g2.setColor((Color)GThemeDefaults.Colors.FOREGROUND);
        this.monitor.setMessage("Printing Page " + (pageIndex + 1));
        this.monitor.initialize(100L);
        if (this.monitor.isCancelled()) {
            this.job.cancel();
            return 1;
        }
        Rectangle rect = new Rectangle((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        if (this.scaleAmount < 1.0) {
            rect = new Rectangle((int)(pageFormat.getImageableWidth() / this.scaleAmount), (int)(pageFormat.getImageableHeight() / this.scaleAmount));
        }
        EmptyLayoutBackgroundColorManager ls = new EmptyLayoutBackgroundColorManager(PAINT_CONTEXT.getBackground());
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Font originalFont = g2.getFont();
        g2.setFont(this.pod.getHeaderFont());
        FontMetrics metrics = g2.getFontMetrics(this.pod.getHeaderFont());
        float bottomPos = (float)pageFormat.getImageableHeight() - (float)metrics.getMaxDescent();
        if (this.pod.getPrintTitle()) {
            GraphicsUtils.drawString(null, (Graphics2D)g2, (String)this.job.getJobName(), (int)0, (int)metrics.getMaxAscent());
        }
        if (this.pod.getPrintDate()) {
            String dateTime = DateUtils.formatDateTimestamp((Date)this.startDate);
            GraphicsUtils.drawString(null, (Graphics2D)g2, (String)dateTime, (int)0, (int)((int)bottomPos));
        }
        if (this.pod.getPrintPageNum()) {
            String pageString = "Page " + (pageIndex + 1) + " of " + this.book.getNumberOfPages();
            GraphicsUtils.drawString(null, (Graphics2D)g2, (String)pageString, (int)((int)(pageFormat.getImageableWidth() - (double)metrics.stringWidth(pageString))), (int)((int)bottomPos));
        }
        g2.setFont(originalFont);
        if (this.pod.showHeader()) {
            g2.translate(0, this.pod.getHeaderHeight());
        }
        if (this.scaleAmount < 1.0) {
            g2.transform(AffineTransform.getScaleInstance(this.scaleAmount, this.scaleAmount));
        }
        if (this.layouts != null) {
            if (this.layouts.size() == 0) {
                return 1;
            }
            for (int i = 0; i < this.layouts.size(); ++i) {
                Layout layout = this.layouts.get(i);
                try {
                    if (layout != null) {
                        layout.paint(null, (Graphics)g2, PAINT_CONTEXT, rect, (LayoutBackgroundColorManager)ls, null);
                        g2.translate(0, layout.getHeight());
                    }
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    i = this.endIndex + 1;
                }
                this.monitor.setProgress((long)((i + 1) * 100 / this.layouts.size()));
            }
        } else {
            for (int i = this.startIndex; i <= this.endIndex; ++i) {
                Layout layout = this.lm.getLayout(BigInteger.valueOf(i));
                try {
                    if (layout != null) {
                        layout.paint(null, (Graphics)g2, PAINT_CONTEXT, rect, (LayoutBackgroundColorManager)ls, null);
                        g2.translate(0, layout.getHeight());
                    }
                }
                catch (Exception e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                    i = this.endIndex + 1;
                }
                this.monitor.setProgress((long)((i - this.startIndex + 1) * 100 / (this.endIndex - this.startIndex + 1)));
            }
        }
        return 0;
    }

    static {
        PAINT_CONTEXT.setForegroundColor((Color)GThemeDefaults.Colors.FOREGROUND);
        PAINT_CONTEXT.setBackgroundColor((Color)GThemeDefaults.Colors.BACKGROUND);
        PAINT_CONTEXT.setCursorColor((Color)GThemeDefaults.Colors.CURSOR);
        PAINT_CONTEXT.setSelectionColor((Color)new GColor("color.bg.selection"));
        PAINT_CONTEXT.setHighlightColor((Color)new GColor("color.bg.highlight"));
        PAINT_CONTEXT.setPrinting(true);
    }
}

