/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.macro.entry;

import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.line.DWARFFile;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroInfoEntry;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileIdType;
import ghidra.util.SourceFileUtils;
import java.io.IOException;

public class DWARFMacroStartFile
extends DWARFMacroInfoEntry {
    public DWARFMacroStartFile(DWARFMacroInfoEntry other) {
        super(other);
    }

    public int getLineNumber() throws IOException {
        return this.getOperand(0, DWARFNumericAttribute.class).getUnsignedIntExact();
    }

    public int getFileNumber() throws IOException {
        return this.getOperand(1, DWARFNumericAttribute.class).getUnsignedIntExact();
    }

    public SourceFile getSourceFile() throws IOException {
        int fileIndex = this.getFileNumber();
        DWARFLine dLine = this.macroHeader.getLine();
        DWARFFile dFile = dLine.getFile(fileIndex);
        String normalizedPath = SourceFileUtils.normalizeDwarfPath(dFile.getPathName(dLine), "DWARF_DEFAULT_COMP_DIR");
        byte[] md5 = dFile.getMD5();
        SourceFileIdType type = md5 == null ? SourceFileIdType.NONE : SourceFileIdType.MD5;
        return new SourceFile(normalizedPath, type, md5);
    }

    @Override
    public String toString() {
        try {
            return "%s: line: %d, filenum: %d %s".formatted(this.getName(), this.getLineNumber(), this.getFileNumber(), this.getSourceFile());
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }
}

