/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.MethodInfo;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@StructureMapping(structureName={"runtime.imethod", "internal/abi.Imethod"})
public class GoIMethod
implements StructureMarkup<GoIMethod> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoIMethod> context;
    @FieldMapping
    @MarkupReference(value="getGoName")
    @EOLComment(value="getName")
    private long name;
    @FieldMapping(fieldName={"ityp", "Typ"})
    @MarkupReference(value="getType")
    private long ityp;

    @Markup
    public GoName getGoName() throws IOException {
        return this.programContext.resolveNameOff(this.context.getStructureStart(), this.name);
    }

    public String getName() {
        GoName n = this.programContext.getSafeName(this::getGoName, this, "unnamed_imethod");
        return n.getName();
    }

    @Markup
    public GoFuncType getType() throws IOException {
        GoFuncType funcType;
        GoType goType = this.programContext.getGoTypes().resolveTypeOff(this.context.getStructureStart(), this.ityp);
        return goType instanceof GoFuncType ? (funcType = (GoFuncType)goType) : null;
    }

    @Override
    public StructureContext<GoIMethod> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getName();
    }

    public String toString() {
        return String.format("GoIMethod [getName()=%s, getStructureContext()=%s]", this.getName(), this.getStructureContext());
    }

    public FunctionDefinition getFunctionDefinition(boolean isGeneric, GoTypeManager goTypes) throws IOException {
        GoFuncType methodFuncDefType = this.getType();
        if (methodFuncDefType == null) {
            return null;
        }
        FunctionDefinition funcdef = methodFuncDefType.getFunctionSignature(goTypes);
        ArrayList<ParameterDefinition> params = new ArrayList<ParameterDefinition>(List.of(funcdef.getArguments()));
        params.add(0, (ParameterDefinition)new ParameterDefinitionImpl("self", goTypes.getVoidPtrDT(), null));
        if (isGeneric) {
            params.add(1, (ParameterDefinition)new ParameterDefinitionImpl("generics_dict", goTypes.getGenericDictDT(), null));
        }
        funcdef.setArguments((ParameterDefinition[])params.toArray(ParameterDefinition[]::new));
        return funcdef;
    }

    public static class GoIMethodInfo
    extends MethodInfo {
        GoItab itab;
        GoIMethod imethod;

        public GoIMethodInfo(GoItab itab, GoIMethod imethod, Address address) {
            super(address);
            this.itab = itab;
            this.imethod = imethod;
        }

        public GoItab getItab() {
            return this.itab;
        }

        public GoIMethod getImethod() {
            return this.imethod;
        }
    }
}

