/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.bplist.BinaryPropertyListTrailer;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BinaryPropertyListHeader
implements StructConverter {
    private String magic;
    private byte majorVersion;
    private byte minorVersion;
    private BinaryPropertyListTrailer trailer;

    public BinaryPropertyListHeader(BinaryReader reader) throws IOException {
        if (reader.isLittleEndian()) {
            throw new IOException("BinaryReader must be BIG endian!");
        }
        this.magic = reader.readNextAsciiString("bplist".length());
        if (!"bplist".equals(this.magic)) {
            throw new IOException("Not a valid binary PLIST");
        }
        this.majorVersion = reader.readNextByte();
        this.minorVersion = reader.readNextByte();
        if (this.majorVersion != 48) {
            throw new IOException("Unsupported binary PLIST version: " + this.majorVersion + "." + this.minorVersion);
        }
        this.trailer = new BinaryPropertyListTrailer(reader);
    }

    public BinaryPropertyListTrailer getTrailer() {
        return this.trailer;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("bplist", 0);
        structure.add(STRING, "bplist".length(), "magic", null);
        structure.add(BYTE, "majorVersion", null);
        structure.add(BYTE, "minorVersion", null);
        return structure;
    }
}

