/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.gnu.GnuDemanglerFormat;

public class GnuDemanglerOptions
extends DemanglerOptions {
    public static final String GNU_DEMANGLER_V2_24 = "demangler_gnu_v2_24";
    public static final String GNU_DEMANGLER_V2_41 = "demangler_gnu_v2_41";
    public static final String GNU_DEMANGLER_DEFAULT = "demangler_gnu_v2_41";
    public static final long DEFAULT_TIMEOUT_SECONDS = 3L;
    private final GnuDemanglerFormat format;
    private final boolean isDeprecated;
    private boolean useStandardReplacements;
    private long timeout;

    public GnuDemanglerOptions() {
        this(GnuDemanglerFormat.AUTO);
    }

    public GnuDemanglerOptions(GnuDemanglerFormat format) {
        this(format, !format.isModernFormat());
    }

    public GnuDemanglerOptions(GnuDemanglerFormat format, boolean isDeprecated) {
        this(format, isDeprecated, 3L);
    }

    public GnuDemanglerOptions(GnuDemanglerFormat format, boolean isDeprecated, long timeoutSeconds) {
        this.format = format;
        this.isDeprecated = isDeprecated;
        this.useStandardReplacements = true;
        this.timeout = timeoutSeconds;
        if (!format.isAvailable(isDeprecated)) {
            throw new IllegalArgumentException(format.name() + " is not available in the " + this.getDemanglerName());
        }
    }

    public GnuDemanglerOptions(DemanglerOptions copy) {
        super(copy);
        if (copy instanceof GnuDemanglerOptions) {
            GnuDemanglerOptions gCopy = (GnuDemanglerOptions)copy;
            this.format = gCopy.format;
            this.isDeprecated = gCopy.isDeprecated;
            this.timeout = gCopy.timeout;
        } else {
            this.format = GnuDemanglerFormat.AUTO;
            this.isDeprecated = false;
            this.timeout = 3L;
        }
        this.useStandardReplacements = true;
    }

    private GnuDemanglerOptions(GnuDemanglerOptions copy, GnuDemanglerFormat format, boolean deprecated, long timeoutSeconds) {
        this(copy, format, deprecated, true, timeoutSeconds);
    }

    private GnuDemanglerOptions(GnuDemanglerOptions copy, GnuDemanglerFormat format, boolean deprecated, boolean useStandardReplacements, long timeoutSeconds) {
        super((DemanglerOptions)copy);
        this.format = format;
        this.isDeprecated = deprecated;
        this.useStandardReplacements = useStandardReplacements;
        this.timeout = timeoutSeconds;
    }

    public void setUseStandardReplacements(boolean replace) {
        this.useStandardReplacements = replace;
    }

    public String getDemanglerName() {
        return this.isDeprecated ? GNU_DEMANGLER_V2_24 : "demangler_gnu_v2_41";
    }

    public GnuDemanglerOptions withDemanglerFormat(GnuDemanglerFormat demanglerFormat, boolean useDeprecated) throws IllegalArgumentException {
        if (this.format == demanglerFormat && this.isDeprecated == useDeprecated) {
            return this;
        }
        if (demanglerFormat.isAvailable(useDeprecated)) {
            return new GnuDemanglerOptions(this, demanglerFormat, useDeprecated, this.timeout);
        }
        throw new IllegalArgumentException(demanglerFormat.name() + " is not available in the " + this.getDemanglerName());
    }

    public String getDemanglerApplicationArguments() {
        if (this.format == GnuDemanglerFormat.AUTO) {
            return "";
        }
        return "-s " + this.format.getFormat();
    }

    public GnuDemanglerFormat getDemanglerFormat() {
        return this.format;
    }

    public boolean shouldUseStandardReplacements() {
        return this.useStandardReplacements;
    }

    public long getTimeoutSeconds() {
        return this.timeout;
    }

    public String toString() {
        return "{\n\tdoDisassembly: " + this.doDisassembly() + ",\n\tapplySignature: " + this.applySignature() + ",\n\tuseStandardReplacements: " + this.useStandardReplacements + ",\n\tdemangleOnlyKnownPatterns: " + this.demangleOnlyKnownPatterns() + ",\n\ttimeout (sec): " + this.timeout + ",\n\tdemanglerName: " + this.getDemanglerName() + ",\n\tdemanglerApplicationArguments: " + this.getDemanglerApplicationArguments() + ",\n}";
    }
}

