/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntBinOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public interface ShiftIntBinOpGen<T extends JitIntBinOp>
extends IntBinOpGen<T> {
    @Override
    default public TypeConversions.Ext rExt() {
        return TypeConversions.Ext.ZERO;
    }

    public String methodName();

    default public JitType.MpIntJitType generateShiftMpPrimitive(JitAllocationModel am, int legCount, JitType.SimpleJitType rType, JitType.MpIntJitType outType, String mdesc, MethodVisitor mv) {
        try (JitAllocationModel.JvmTempAlloc tmpL = am.allocateTemp(mv, "tmpL", legCount);
             JitAllocationModel.JvmTempAlloc tmpR = am.allocateTemp(mv, "tmpR", rType.javaType(), 1);){
            mv.visitVarInsn(rType.opcodeStore(), tmpR.idx(0));
            OpGen.generateMpLegsIntoTemp(tmpL, legCount, mv);
            mv.visitLdcInsn((Object)outType.legsAlloc());
            mv.visitIntInsn(188, 10);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)outType.size());
            OpGen.generateMpLegsIntoArray(tmpL, legCount, legCount, mv);
            mv.visitVarInsn(rType.opcodeLoad(), tmpR.idx(0));
            mv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), mdesc, true);
            OpGen.generateMpLegsFromArray(outType.legsAlloc(), mv);
        }
        return outType.ext();
    }

    default public JitType.SimpleJitType generateShiftPrimitiveMp(JitAllocationModel am, JitType.SimpleJitType lType, int legCount, String mdesc, MethodVisitor mv) {
        try (JitAllocationModel.JvmTempAlloc tmpR = am.allocateTemp(mv, "tmpR", legCount);){
            OpGen.generateMpLegsIntoTemp(tmpR, legCount, mv);
            OpGen.generateMpLegsIntoArray(tmpR, legCount, legCount, mv);
            mv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), mdesc, true);
        }
        return lType.ext();
    }

    default public JitType.MpIntJitType generateShiftMpMp(JitAllocationModel am, int leftLegCount, int rightLegCount, JitType.MpIntJitType outType, MethodVisitor mv) {
        try (JitAllocationModel.JvmTempAlloc tmpL = am.allocateTemp(mv, "tmpL", leftLegCount);
             JitAllocationModel.JvmTempAlloc tmpR = am.allocateTemp(mv, "tmpR", rightLegCount);){
            OpGen.generateMpLegsIntoTemp(tmpR, rightLegCount, mv);
            OpGen.generateMpLegsIntoTemp(tmpL, leftLegCount, mv);
            int outLegCount = outType.legsAlloc();
            mv.visitLdcInsn((Object)outLegCount);
            mv.visitIntInsn(188, 10);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)outType.size());
            OpGen.generateMpLegsIntoArray(tmpL, leftLegCount, leftLegCount, mv);
            OpGen.generateMpLegsIntoArray(tmpR, rightLegCount, rightLegCount, mv);
            mv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), GenConsts.MDESC_$SHIFT_AA, true);
            OpGen.generateMpLegsFromArray(outLegCount, mv);
        }
        return outType;
    }

    @Override
    default public JitType generateBinOpRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitAllocationModel am = gen.getAllocationModel();
        JitType jitType = lType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType lt = (JitType.IntJitType)jitType2;
                JitType v1 = rType;
                Objects.requireNonNull(v1);
                JitType var14_11 = v1;
                int var15_13 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var14_11, var15_13)) {
                    case 0: {
                        JitType.IntJitType rt = (JitType.IntJitType)var14_11;
                        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), GenConsts.MDESC_$SHIFT_II, true);
                        yield lType.ext();
                    }
                    case 1: {
                        JitType.LongJitType rt = (JitType.LongJitType)var14_11;
                        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), GenConsts.MDESC_$SHIFT_IJ, true);
                        yield lType.ext();
                    }
                    case 2: {
                        JitType.MpIntJitType rt = (JitType.MpIntJitType)var14_11;
                        yield this.generateShiftPrimitiveMp(am, lt, rt.legsAlloc(), GenConsts.MDESC_$SHIFT_IA, rv);
                    }
                }
                throw new AssertionError();
            }
            case 1 -> {
                JitType.LongJitType lt = (JitType.LongJitType)jitType2;
                JitType v3 = rType;
                Objects.requireNonNull(v3);
                JitType var18_18 = v3;
                int var19_20 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var18_18, var19_20)) {
                    case 0: {
                        JitType.IntJitType rt = (JitType.IntJitType)var18_18;
                        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), GenConsts.MDESC_$SHIFT_JI, true);
                        yield lType.ext();
                    }
                    case 1: {
                        JitType.LongJitType rt = (JitType.LongJitType)var18_18;
                        rv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, this.methodName(), GenConsts.MDESC_$SHIFT_JJ, true);
                        yield lType.ext();
                    }
                    case 2: {
                        JitType.MpIntJitType rt = (JitType.MpIntJitType)var18_18;
                        yield this.generateShiftPrimitiveMp(am, lt, rt.legsAlloc(), GenConsts.MDESC_$SHIFT_JA, rv);
                    }
                }
                throw new AssertionError();
            }
            case 2 -> {
                JitType.MpIntJitType lt = (JitType.MpIntJitType)jitType2;
                JitType v4 = rType;
                Objects.requireNonNull(v4);
                JitType var22_24 = v4;
                int var23_25 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var22_24, var23_25)) {
                    case 0: {
                        JitType.IntJitType rt = (JitType.IntJitType)var22_24;
                        yield this.generateShiftMpPrimitive(am, lt.legsAlloc(), rt, JitType.MpIntJitType.forSize(op.out().size()), GenConsts.MDESC_$SHIFT_AI, rv);
                    }
                    case 1: {
                        JitType.LongJitType rt = (JitType.LongJitType)var22_24;
                        yield this.generateShiftMpPrimitive(am, lt.legsAlloc(), rt, JitType.MpIntJitType.forSize(op.out().size()), GenConsts.MDESC_$SHIFT_AJ, rv);
                    }
                    case 2: {
                        JitType.MpIntJitType rt = (JitType.MpIntJitType)var22_24;
                        yield this.generateShiftMpMp(am, lt.legsAlloc(), rt.legsAlloc(), JitType.MpIntJitType.forSize(op.out().size()), rv);
                    }
                }
                throw new AssertionError();
            }
            default -> throw new AssertionError();
        };
    }
}

