/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.microsoft;

import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.microsoft.MsCInterpretation;

public class MicrosoftDemanglerOptions
extends DemanglerOptions {
    private boolean errorOnRemainingChars;
    private MsCInterpretation interpretation;

    public MicrosoftDemanglerOptions() {
        this(true);
        this.interpretation = MsCInterpretation.FUNCTION_IF_EXISTS;
    }

    public MicrosoftDemanglerOptions(boolean errorOnRemainingChars) {
        this.errorOnRemainingChars = errorOnRemainingChars;
    }

    public MicrosoftDemanglerOptions(DemanglerOptions copy) {
        super(copy);
        if (copy instanceof MicrosoftDemanglerOptions) {
            MicrosoftDemanglerOptions mCopy = (MicrosoftDemanglerOptions)copy;
            this.errorOnRemainingChars = mCopy.errorOnRemainingChars;
            this.interpretation = mCopy.interpretation;
        } else {
            this.errorOnRemainingChars = true;
            this.interpretation = MsCInterpretation.FUNCTION_IF_EXISTS;
        }
    }

    public void setErrorOnRemainingChars(boolean errorOnRemainingCharsArg) {
        this.errorOnRemainingChars = errorOnRemainingCharsArg;
    }

    public boolean errorOnRemainingChars() {
        return this.errorOnRemainingChars;
    }

    public void setInterpretation(MsCInterpretation interpretationArg) {
        this.interpretation = interpretationArg;
    }

    public MsCInterpretation getInterpretation() {
        return this.interpretation;
    }

    public String toString() {
        return "{\n\tdoDisassembly: " + this.doDisassembly() + ",\n\tapplySignature: " + this.applySignature() + ",\n\terrorOnRemainingChars: " + this.errorOnRemainingChars + ",\n\tinterpretation: " + String.valueOf((Object)this.interpretation) + ",\n\tdemangleOnlyKnownPatterns: " + this.demangleOnlyKnownPatterns() + ",\n}";
    }
}

