---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: エピック、イシュー、マイルストーン、ラベル。
title: 作業を計画および追跡する
---

要件、イシュー、エピックを作成して作業を計画します。マイルストーンで作業のスケジュールを立て、チームの時間を追跡します。クイックアクションで時間を節約する方法、GitLabでのMarkdownテキスト表示の仕組み、Gitを使用してGitLabを操作する方法について説明します。

<!-- vale gitlab_base.Spelling = NO -->

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>Plan機能の詳しいデモについては、[Multi-team planning with GitLab Ultimate](https://www.youtube.com/watch?v=KmASFwSap7c)をご覧ください。この動画では、GabeがScaled Agile Framework（SAFe）でGitLabを使用するマルチチーム組織のユースケースについて説明しています。または、[GitLabのサイロ化がないSAFe](https://about.gitlab.com/blog/2025/04/08/safe-without-silos-in-gitlab/)を参照して、GitLabでSAFeをマップする方法を確認してください。

<!-- vale gitlab_base.Spelling = YES -->

{{< cards >}}

- [はじめに](../user/get_started/get_started_planning_work.md)
- [チュートリアル: ScrumにGitLabを使用する](../tutorials/scrum_events/_index.md)
- [チュートリアル: KanbanにGitLabを使用する](../tutorials/kanban/_index.md)
- [ラベル](../user/project/labels.md)
- [イテレーション](../user/group/iterations/_index.md)
- [マイルストーン](../user/project/milestones/_index.md)
- [イシュー](../user/project/issues/_index.md)
- [イシューボード](../user/project/issue_board.md)
- [コメントとスレッド](../user/discussions/_index.md)
- [タスク](../user/tasks.md)
- [要件](../user/project/requirements/_index.md)
- [タイムトラッキング](../user/project/time_tracking.md)
- [CRM](../user/crm/_index.md)
- [Wiki](../user/project/wiki/_index.md)
- [エピック](../user/group/epics/_index.md)
- [ロードマップ](../user/group/roadmap/_index.md)
- [目標と主な成果](../user/okrs.md)
- [To-Doリスト](../user/todos.md)
- [キーボードショートカット](../user/shortcuts.md)
- [クイックアクション](../user/project/quick_actions.md)
- [Markdown](../user/markdown.md)

{{< /cards >}}
