# frozen_string_literal: true

class IncreaseVulnerabilityFlagsDescriptionLength < Gitlab::Database::Migration[2.3]
  milestone '18.6'

  disable_ddl_transaction!

  OLD_CONSTRAINT_NAME = 'check_45e743349f'
  NEW_CONSTRAINT_NAME = 'check_vulnerability_flags_description_length'

  def up
    add_check_constraint :vulnerability_flags, 'char_length(description) <= 100000', NEW_CONSTRAINT_NAME
    remove_check_constraint :vulnerability_flags, OLD_CONSTRAINT_NAME
  end

  def down
    # noop: there can be rows with char length over 10000
  end
end
