---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab deploy token'
---

## Description

The response body contains content that matches the pattern of a GitLab deploy token was identified. A deploy token enables authentication of deployment tasks, independent of a user account. With a deploy token, automated tasks can: - Clone Git repositories - Pull from and push to a GitLab container registry - Pull from and push to a GitLab package registry A malicious actor with access to this token can access Git repositories or compromise released packages or containers.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

For more information, please see [GitLabs documentation on revoking deploy tokens](../../../../../user/project/deploy_tokens/_index.md).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.150 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
