---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Vulnerability management policy schema
---

The YAML file with vulnerability management policies consists of an array of objects matching
the vulnerability management policy schema nested under the `vulnerability_management_policy` key.

When you save a vulnerability management policy, its content is validated against the vulnerability
management policy schema. If you're not familiar with how to read
[JSON schemas](https://json-schema.org/), the following sections and tables provide an alternative.

| Field                             | Type                                       | Required | Description |
|-----------------------------------|--------------------------------------------|----------|-------------|
| `vulnerability_management_policy` | `array` of vulnerability management policy | true     | List of vulnerability management policies (maximum 5) |

## Vulnerability management policy

| Field          | Type                                         | Required | Description |
|----------------|----------------------------------------------|----------|-------------|
| `name`         | `string`                                     | true     | Name of the policy. Maximum of 255 characters. |
| `description`  | `string`                                     | false    | Description of the policy. |
| `enabled`      | `boolean`                                    | true     | Flag to enable (`true`) or disable (`false`) the policy. |
| `rules`        | `array` of rules                             | true     | List of rules that define the policy's criteria. |
| `policy_scope` | `object` of [`policy_scope`](_index.md#configure-the-policy-scope) | false    | Scope of the policy, based on the projects, groups, or compliance framework labels you specify. |
| `actions`      | `array` of actions                           | true     | Action to be taken on vulnerabilities matching the policy. |

### `no_longer_detected` rule

This rule defines the criteria for the policy.

| Field | Type | Required | Possible values | Description |
|-------|------|----------|-----------------|-------------|
| `type` | `string` | true | `no_longer_detected` | The rule's type. |
| `scanners` | `array` | `true` | `sast`, `secret_detection`, `dependency_scanning`, `container_scanning`, `dast`, `coverage_fuzzing`, `api_fuzzing` | Specifies the scanners for which this policy is enforced. |
| `severity_levels` | `array` | `true` | `critical`, `high`, `medium`, `low`, `info`, `unknown` | Specifies the severity levels for which this policy is enforced. |

### `auto_resolve` action

This action resolves vulnerabilities matching the policy's rules and scope.

| Field  | Type     | Required | Possible values | Description |
|--------|----------|----------|-----------------|-------------|
| `type` | `string` | true     | `auto_resolve`  | The action's type. |
