# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: commit.proto for package 'gitaly'

require 'grpc'
require 'commit_pb'

module Gitaly
  module CommitService
    # CommitService is a service which provides RPCs that interact with Git
    # commits.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.CommitService'

      # ListCommits lists all commits reachable via a set of references by doing a
      # graph walk. This deprecates FindAllCommits and FindCommits (except Follow
      # is not yet supported). Any unknown revisions will cause the RPC to fail.
      rpc :ListCommits, ::Gitaly::ListCommitsRequest, stream(::Gitaly::ListCommitsResponse)
      # ListAllCommits lists all commits present in the repository, including
      # those not reachable by any reference.
      rpc :ListAllCommits, ::Gitaly::ListAllCommitsRequest, stream(::Gitaly::ListAllCommitsResponse)
      # CommitIsAncestor checks whether a provided commit is the ancestor of
      # another commit.
      rpc :CommitIsAncestor, ::Gitaly::CommitIsAncestorRequest, ::Gitaly::CommitIsAncestorResponse
      # TreeEntry provides the tree entry for the provided path and revision. The data
      # is broken into chunks and streamed.
      rpc :TreeEntry, ::Gitaly::TreeEntryRequest, stream(::Gitaly::TreeEntryResponse)
      # CountCommits provides the number of commits which adhere to the given filters.
      rpc :CountCommits, ::Gitaly::CountCommitsRequest, ::Gitaly::CountCommitsResponse
      # CountDivergingCommits provides the number of diverging commits between two revisions.
      rpc :CountDivergingCommits, ::Gitaly::CountDivergingCommitsRequest, ::Gitaly::CountDivergingCommitsResponse
      # GetTreeEntries provides the tree entries for the provided path and revision. This includes
      # subtrees present under the tree with the option of recursive fetching.
      rpc :GetTreeEntries, ::Gitaly::GetTreeEntriesRequest, stream(::Gitaly::GetTreeEntriesResponse)
      # ListFiles lists all the files (including files in sub-dirs) present in the working tree
      # of a given treeish.
      rpc :ListFiles, ::Gitaly::ListFilesRequest, stream(::Gitaly::ListFilesResponse)
      # FindCommit finds a commit for a given commitish. Returns nil if the commit is not found.
      rpc :FindCommit, ::Gitaly::FindCommitRequest, ::Gitaly::FindCommitResponse
      # CommitStats provides the stats for a given commitish.
      rpc :CommitStats, ::Gitaly::CommitStatsRequest, ::Gitaly::CommitStatsResponse
      # FindAllCommits lists all the commits which can be traversed from the
      # provided commitish.
      # DEPRECATED: https://gitlab.com/gitlab-org/gitaly/-/issues/6846
      rpc :FindAllCommits, ::Gitaly::FindAllCommitsRequest, stream(::Gitaly::FindAllCommitsResponse)
      # FindCommits lists all the commits which are associated with the provided revision
      # and paths.
      # DEPRECATED: https://gitlab.com/gitlab-org/gitaly/-/issues/6845
      rpc :FindCommits, ::Gitaly::FindCommitsRequest, stream(::Gitaly::FindCommitsResponse)
      # CommitLanguages detects the source code languages of the whole tree for a
      # given commit. Returns an error in case no languages could be detected.
      rpc :CommitLanguages, ::Gitaly::CommitLanguagesRequest, ::Gitaly::CommitLanguagesResponse
      # RawBlame blames lines in a blob to when they have last been changed. Returns the raw output of the git-blame(1)
      # command.
      rpc :RawBlame, ::Gitaly::RawBlameRequest, stream(::Gitaly::RawBlameResponse)
      # LastCommitForPath returns the last commit that has changed a given path.
      #
      # The following special cases apply and have grown historically:
      #
      # - Absolute paths that or relative paths that escape the repository root will cause an error.
      # - A nonexistent path inside the repository leads to a successful but empty response.
      rpc :LastCommitForPath, ::Gitaly::LastCommitForPathRequest, ::Gitaly::LastCommitForPathResponse
      # ListLastCommitsForTree lists the last commits for a given tree.
      rpc :ListLastCommitsForTree, ::Gitaly::ListLastCommitsForTreeRequest, stream(::Gitaly::ListLastCommitsForTreeResponse)
      # CommitsByMessage list commits which match the provided query.
      rpc :CommitsByMessage, ::Gitaly::CommitsByMessageRequest, stream(::Gitaly::CommitsByMessageResponse)
      # ListCommitsByOid lists the commits for the provided commitish object IDs.
      rpc :ListCommitsByOid, ::Gitaly::ListCommitsByOidRequest, stream(::Gitaly::ListCommitsByOidResponse)
      # ListCommitsByRefName lists the commits for the provided references.
      rpc :ListCommitsByRefName, ::Gitaly::ListCommitsByRefNameRequest, stream(::Gitaly::ListCommitsByRefNameResponse)
      # FilterShasWithSignatures filters out signed commits.
      rpc :FilterShasWithSignatures, stream(::Gitaly::FilterShasWithSignaturesRequest), stream(::Gitaly::FilterShasWithSignaturesResponse)
      # GetCommitSignatures parses the commit signature information for the provided commitish object IDs.
      # The RPC doesn't use 'mailmap' to ensure that signature verification is done against the original
      # information which contains the non-mapped commit author.
      rpc :GetCommitSignatures, ::Gitaly::GetCommitSignaturesRequest, stream(::Gitaly::GetCommitSignaturesResponse)
      # GetCommitMessages returns the commits messages for the provided commitish object IDs.
      rpc :GetCommitMessages, ::Gitaly::GetCommitMessagesRequest, stream(::Gitaly::GetCommitMessagesResponse)
      # CheckObjectsExist will check for the existence of revisions against a
      # repository. It returns two sets of data. An array containing the revisions
      # from the input that it found on the repository, and an array that contains all
      # revisions from the input it did not find on the repository.
      rpc :CheckObjectsExist, stream(::Gitaly::CheckObjectsExistRequest), stream(::Gitaly::CheckObjectsExistResponse)
    end

    Stub = Service.rpc_stub_class
  end
end
