require File.expand_path '../test_helper', __dir__

class TestCredentials < Minitest::Test
  def setup
    @token = 'test-access-token'
    @expires_at = Time.now + 3600 # 1 hour from now
    @credentials = Fog::AzureRM::Identity::Credentials.new(@token, @expires_at)
  end

  def test_initialize
    assert_equal @token, @credentials.token
    assert_equal @expires_at, @credentials.expires_at
  end

  def test_refresh_needed_when_expires_at_is_nil
    credentials = Fog::AzureRM::Identity::Credentials.new(@token, nil)
    assert credentials.refresh_needed?
  end

  def test_refresh_needed_when_token_expires_soon
    # Token expires in 5 minutes (less than 10 minute buffer)
    expires_soon = Time.now + 300
    credentials = Fog::AzureRM::Identity::Credentials.new(@token, expires_soon)
    assert credentials.refresh_needed?
  end

  def test_refresh_not_needed_when_token_has_time_left
    # Token expires in 15 minutes (more than 10 minute buffer)
    expires_later = Time.now + 900
    credentials = Fog::AzureRM::Identity::Credentials.new(@token, expires_later)
    refute credentials.refresh_needed?
  end

  def test_refresh_needed_exactly_at_buffer_time
    # Token expires exactly at buffer time (10 minutes)
    expires_at_buffer = Time.now + Fog::AzureRM::Identity::Credentials::EXPIRATION_BUFFER
    credentials = Fog::AzureRM::Identity::Credentials.new(@token, expires_at_buffer)
    assert credentials.refresh_needed?
  end

  def test_expiration_buffer_constant
    assert_equal 600, Fog::AzureRM::Identity::Credentials::EXPIRATION_BUFFER
  end
end
