# google-cloud-env

This library provides information on the application hosting environment for
apps running on Google Cloud Platform. This includes information on the Google
compute product being used, the current project and credentials, and other
information surfaced via environment variables, the file system, and the
Metadata Server.

- [google-cloud-env API documentation](https://googleapis.dev/ruby/google-cloud-env/latest)

## Supported Ruby Versions

This library is supported on Ruby 3.0+.

In general, Google provides official support for CRuby versions that are
actively supported by the Ruby Core team -- that is, Ruby versions that are
either in normal maintenance or in security maintenance -- and for about one
year after end of life. Older versions of Ruby _may_ still work, but are
unsupported and not recommended. See
https://www.ruby-lang.org/en/downloads/branches/ for more details about the
Ruby-Core support schedule. See 
https://cloud.google.com/ruby/getting-started/supported-ruby-versions for more
details about Google's Ruby support schedule.

## Contributing

Contributions to this library are always welcome and highly encouraged.

See the [Contributing
Guide](https://googleapis.dev/ruby/google-cloud-env/latest/file.CONTRIBUTING.html)
for more information on how to get started.

Please note that this project is released with a Contributor Code of Conduct. By
participating in this project you agree to abide by its terms. See [Code of
Conduct](https://googleapis.dev/ruby/google-cloud-env/latest/file.CODE_OF_CONDUCT.html)
for more information.

## License

This library is licensed under Apache 2.0. Full license text is available in
[LICENSE](https://googleapis.dev/ruby/google-cloud-env/latest/file.LICENSE.html).

## Support

Please [report bugs at the project on
Github](https://github.com/googleapis/google-cloud-ruby/issues). Don't
hesitate to [ask
questions](http://stackoverflow.com/questions/tagged/google-cloud-platform+ruby)
about the client or APIs on [StackOverflow](http://stackoverflow.com).
