---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: "作業アイテムのワークフローにおける特定のステップ（「進行中」、「完了」、「対応しない」）であり、カテゴリに属し、バイナリステート（オープン/クローズ）にマップされます。"
title: ステータス
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 18.2で`work_item_status_feature_flag`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/543862)されました。デフォルトでは有効になっています。
- GitLab 18.4で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/521286)になりました。機能フラグ`work_item_status_feature_flag`は削除されました。

{{< /history >}}

<!-- Turn off the future tense test because of "won't do". -->
<!-- vale gitlab_base.FutureTense = NO -->

作業アイテムのステータスは、アイテムのワークフローにおける特定のステップを表します（例: **進行中**、**完了**、**対応しない**）。ステータスを使用すると、GitLab Freeで使用されている従来のバイナリのオープン/クローズステートシステムよりも詳細な追跡が可能です。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>ビデオの概要については、[イシューとタスクの設定可能なステータス-完全なウォークスルー（GitLab 18.2）](https://www.youtube.com/watch?v=oxN95MSo6UU)を参照してください。
<!-- Video published on 2025-07-11 -->

ステータスを使用して、以下を行います:

- 完了のさまざまなステージングで作業アイテムを追跡します。
- 作業アイテムの進捗状況をより明確に可視化します。
- ラベルを使用して作業アイテムのライフサイクルを管理する必要性をなくします。
- チームとプロジェクト全体でワークフローを標準化します。

ステータスは、タスクとイシューで使用できます。エピックや他の作業アイテムタイプにステータスを追加する計画については、[epic 5099](https://gitlab.com/groups/gitlab-org/-/epics/5099)を参照してください。

## デフォルト状態 {#default-statuses}

GitLabには、作業アイテムの追跡を開始するためのデフォルトのステータスが用意されています。これらのステータスは変更できません。

デフォルトのステータスは次のとおりです:

- **To do**（To Do）: 作業アイテムを開始する準備ができました。
- **進行中**: 作業アイテムが積極的に処理されています。
- **完了**: 作業アイテムが完了しました。
- **Won't do**（対応しない）: 作業アイテムは完了しません。
- **複製**: 作業アイテムは別のアイテムの複製です。

## ステータスカテゴリ {#status-categories}

ステータスカテゴリは、ステータスが作業アイテムの状態とアイコンにどのように影響するかを決定する論理的なグループです。各ステータスは、次の5つのカテゴリのいずれかに属します:

- **トリアージ**: 新規または未処理の作業アイテムの場合。
- **To do**（To Do）: 開始する準備ができている作業アイテムの場合。
- **進行中**: 積極的に処理されている作業アイテムの場合。
- **完了**: 完了した作業アイテムの場合。
- **キャンセル済み**: 完了しない作業アイテムの場合。

**完了**および**キャンセル済み**カテゴリのステータスは、作業アイテムを自動的にクローズ状態に設定します。他のすべてのカテゴリは、作業アイテムをオープン状態に維持します。

<!-- vale gitlab_base.FutureTense = YES -->

## ライフサイクル {#lifecycles}

{{< history >}}

- GitLab 18.5で`work_item_status_mvc2`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/556113)されました。デフォルトでは有効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

ライフサイクルとは、作業アイテムタイプに適用できるステータスのコレクションです。ライフサイクルは、ステータスを作業アイテムタイプとネームスペース全体で一貫して再利用できる意味のあるワークフローにグループ化します。

各ライフサイクルは、デフォルトの移行ステータスを定義します:

- **Default open status**（デフォルトのオープンステータス）: 作業アイテムの作成時および再オープン時に適用されます。
- **Default closed status**（デフォルトのクローズステータス）: 作業アイテムをクローズするときに適用されます。
- **Default duplicated status**（デフォルトの複製ステータス）: 作業アイテムを複製、移動、またはプロモートとしてマークするときに適用されます。

### ライフサイクルの作成 {#create-a-lifecycle}

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。
- このグループはトップレベルにある必要があります。

ライフサイクルを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. **ステータス**セクションで、**ライフサイクルを作成**を選択します。
1. ライフサイクル名を追加し、デフォルトのライフサイクル構成か、既存のライフサイクルのいずれかを選択して、そこから開始します。これにより、新しいライフサイクルにステータスが自動入力され、後でカスタマイズできます。
1. **作成**を選択します。

### ライフサイクルの名前を変更 {#rename-a-lifecycle}

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。
- このグループはトップレベルにある必要があります。

ライフサイクルの名前を変更するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. **ステータス**セクションで、ライフサイクルの詳細ビューにカーソルを合わせます。
1. **名前を変更**を選択します。
1. ライフサイクルの名前を変更し、**保存**を選択します。

### ライフサイクルの除去 {#remove-a-lifecycle}

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。
- このグループはトップレベルにある必要があります。
- ライフサイクルは使用中でない必要があります。つまり、どの作業アイテムタイプにも関連付けられていない必要があります

ライフサイクルを除去するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. **ステータス**セクションで、除去するライフサイクルの**ライフサイクルを除去**を選択します。
1. 確認で、**削除**を選択します。

### 作業アイテムタイプのライフサイクルの変更 {#change-lifecycle-for-a-work-item-type}

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。
- このグループはトップレベルにある必要があります。

作業アイテムタイプのライフサイクルを変更するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. **ステータス**セクションで、次のいずれかを行います:
   - **ライフサイクルを変更**を選択します。
   - ライフサイクルが複数の作業アイテムタイプで使用されている場合は、ドロップダウンリストから選択します。
1. 作業アイテムタイプの新しいライフサイクルを選択します。既存のライフサイクルを選択するか、新しいライフサイクルを作成できます。
1. **次へ**を選択します。

   現在のすべてのステータスに、新しいライフサイクルからのどの新しいステータスが表示されるかが表示されます。

1. オプション。別の代替ステータスを選択するには、ドロップダウンリストから選択します。
1. **保存**を選択します。

## カスタムステータス {#custom-statuses}

カスタムステータスは、ネームスペース定義のステータスであり、そのネームスペース内のすべてのグループおよびプロジェクトのデフォルトのステータスを置き換えます。ライフサイクルを編集すると、カスタムステータスがそのネームスペースのデフォルトのステータスに置き換わります。

カスタムステータスには、次の制限があります:

- 1つのネームスペースあたり最大70個のステータス
- 1つのライフサイクルあたり最大30個のステータス

### ネームスペースのカスタムステータスを設定する {#configure-custom-statuses-for-a-namespace}

トップレベルグループのカスタムステータスを設定して、そのグループ、サブグループ、およびプロジェクト内の作業アイテムで使用できるようにします。

前提要件: 

- グループのメンテナーロール以上を持っている必要があります。
- このグループはトップレベルにある必要があります。

カスタムステータスを設定するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで、**設定** > **イシュー**を選択します。
1. **ステータス**セクションで、作業アイテムタイプで使用されているライフサイクルの**ステータスの編集**を選択します。
1. ネームスペースのステータスを追加、編集、または並べ替えます。
1. **閉じる**を選択します。

### 作業アイテムのステータスを設定 {#set-status-for-a-work-item}

前提要件: 

- 作業アイテムのプロジェクトまたはグループに対するプランナーロール、作業アイテムの作成者、または作業アイテムに割り当てられているロールが少なくとも必要です。

作業アイテムのステータスを設定するには:

1. イシューまたはタスクに移動します。
1. 右側のサイドバーの**ステータス**セクションで、**編集**を選択します。
1. 目的の状態を選択します。
1. ドロップダウンリストの外側の領域を選択します。

作業アイテムのステータスがすぐに更新されます。
