import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { InlineField, InlineSwitch } from '@grafana/ui';
import { config } from '@grafana/runtime';
import '@grafana/data';

const SecureSocksProxyToggle = ({ labelWidth = 10, ...props }) => {
  const { dataSourceConfig, onChange } = props;
  const handleSwitchChange = (e) => {
    onChange({
      ...dataSourceConfig,
      jsonData: {
        ...dataSourceConfig.jsonData,
        enableSecureSocksProxy: e.target.checked
      }
    });
  };
  return config.secureSocksDSProxyEnabled && /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx("div", { className: "gf-form gf-form-inline", children: /* @__PURE__ */ jsx(
    InlineField,
    {
      htmlFor: "secureSocksProxyEnabled",
      label: "Secure Socks Proxy Enabled",
      labelWidth,
      tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
        "Proxy the datasource connection through the secure socks proxy to a different network. To learn more about configuring the datasource connection proxy,",
        " ",
        /* @__PURE__ */ jsx(
          "a",
          {
            href: "https://grafana.com/docs/grafana/latest/setup-grafana/configure-grafana/proxy/",
            target: "_blank",
            rel: "noopener noreferrer",
            children: "click here."
          }
        )
      ] }),
      children: /* @__PURE__ */ jsx(
        InlineSwitch,
        {
          id: "secureSocksProxyEnabled",
          value: dataSourceConfig.jsonData.enableSecureSocksProxy,
          onChange: handleSwitchChange
        }
      )
    }
  ) }) }) });
};

export { SecureSocksProxyToggle };
//# sourceMappingURL=SecureSocksProxyToggle.js.map
