import { c as chanceExports } from '../../_virtual/chance.js';
import { PluginType, PluginIncludeType, PluginState, PluginSignatureStatus } from '@grafana/data';
import { generateBoolean } from './utils.js';

const mockDataSourcePluginMeta = () => ({
  builtIn: generateBoolean(),
  metrics: generateBoolean(),
  logs: generateBoolean(),
  annotations: generateBoolean(),
  alerting: generateBoolean(),
  tracing: generateBoolean(),
  mixed: generateBoolean(),
  hasQueryHelp: generateBoolean(),
  category: chanceExports.Chance().word(),
  queryOptions: {
    cacheTimeout: generateBoolean(),
    maxDataPoints: generateBoolean(),
    minInterval: generateBoolean()
  },
  sort: 1,
  streaming: generateBoolean(),
  unlicensed: generateBoolean(),
  id: chanceExports.Chance().word(),
  name: chanceExports.Chance().word(),
  type: mockPluginType(),
  info: mockPluginMetaInfo(),
  module: chanceExports.Chance().word(),
  baseUrl: chanceExports.Chance().word()
});
const mockPluginMetaInfo = () => ({
  author: {
    name: chanceExports.Chance().word(),
    url: chanceExports.Chance().word()
  },
  description: chanceExports.Chance().word(),
  links: [],
  logos: {
    large: chanceExports.Chance().word(),
    small: chanceExports.Chance().word()
  },
  screenshots: [],
  updated: chanceExports.Chance().word(),
  version: chanceExports.Chance().word()
});
const mockPluginMeta = () => ({
  id: chanceExports.Chance().word(),
  name: chanceExports.Chance().word(),
  type: mockPluginType(),
  info: mockPluginMetaInfo(),
  includes: [mockPluginInclude()],
  state: mockPluginState(),
  module: chanceExports.Chance().word(),
  baseUrl: chanceExports.Chance().word(),
  dependencies: mockPluginDependencies(),
  jsonData: {},
  secureJsonData: {},
  enabled: generateBoolean(),
  defaultNavUrl: chanceExports.Chance().word(),
  hasUpdate: generateBoolean(),
  enterprise: generateBoolean(),
  latestVersion: chanceExports.Chance().word(),
  pinned: generateBoolean(),
  signature: mockPluginSignatureStatus(),
  live: generateBoolean()
});
const mockPluginInclude = () => ({
  type: mockPluginIncludeType(),
  name: chanceExports.Chance().word(),
  path: chanceExports.Chance().word(),
  icon: chanceExports.Chance().word(),
  role: chanceExports.Chance().word(),
  addToNav: generateBoolean(),
  component: chanceExports.Chance().word()
});
const mockPluginType = () => chanceExports.Chance().pickone([PluginType.panel, PluginType.datasource, PluginType.app, PluginType.renderer]);
const mockPluginIncludeType = () => chanceExports.Chance().pickone([
  PluginIncludeType.dashboard,
  PluginIncludeType.page,
  PluginIncludeType.panel,
  PluginIncludeType.datasource
]);
const mockPluginState = () => chanceExports.Chance().pickone([PluginState.alpha, PluginState.beta, PluginState.deprecated]);
const mockPluginDependencies = () => ({
  grafanaVersion: chanceExports.Chance().word(),
  plugins: []
});
const mockPluginSignatureStatus = () => chanceExports.Chance().pickone([
  PluginSignatureStatus.internal,
  PluginSignatureStatus.valid,
  PluginSignatureStatus.invalid,
  PluginSignatureStatus.modified,
  PluginSignatureStatus.missing
]);

export { mockDataSourcePluginMeta, mockPluginDependencies, mockPluginInclude, mockPluginIncludeType, mockPluginMeta, mockPluginMetaInfo, mockPluginSignatureStatus, mockPluginState, mockPluginType };
//# sourceMappingURL=Plugin.js.map
