#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tomland
version:              1.3.3.3
visibility:           public
id:                   tomland-1.3.3.3-7bqNVFOAtTuDZxKEcBVEq
key:                  tomland-1.3.3.3-7bqNVFOAtTuDZxKEcBVEq
license:              MPL-2.0
copyright:            2018-2023 Kowainik
maintainer:           Kowainik <xrom.xkov@gmail.com>
author:               Dmitrii Kovanikov, Veronika Romashkina
homepage:             https://github.com/kowainik/tomland
synopsis:             Bidirectional TOML serialization
description:
    Implementation of bidirectional TOML serialization. Simple codecs look like this:

    @
    __data__ User = User
    \    { userName :: Text
    \    , userAge  :: Int
    \    }
    \
    \userCodec :: TomlCodec User
    \userCodec = User
    \    \<$\> Toml.text "name" .= userName
    \    \<*\> Toml.int  "age"  .= userAge
    @

    The following blog post has more details about library design:

    * [tomland: Bidirectional TOML serialization](https://kowainik.github.io/posts/2019-01-14-tomland)

category:             TOML, Text, Configuration
abi:                  707c36e07291e90938afd6651912ed57
exposed:              True
exposed-modules:
    Toml Toml.Codec Toml.Codec.BiMap Toml.Codec.BiMap.Conversion
    Toml.Codec.Code Toml.Codec.Combinator Toml.Codec.Combinator.Common
    Toml.Codec.Combinator.Custom Toml.Codec.Combinator.List
    Toml.Codec.Combinator.Map Toml.Codec.Combinator.Monoid
    Toml.Codec.Combinator.Primitive Toml.Codec.Combinator.Set
    Toml.Codec.Combinator.Table Toml.Codec.Combinator.Time
    Toml.Codec.Combinator.Tuple Toml.Codec.Di Toml.Codec.Error
    Toml.Codec.Generic Toml.Codec.Types Toml.Parser Toml.Parser.Core
    Toml.Parser.Item Toml.Parser.Key Toml.Parser.String
    Toml.Parser.Validate Toml.Parser.Value Toml.Type Toml.Type.AnyValue
    Toml.Type.Edsl Toml.Type.Key Toml.Type.PrefixTree Toml.Type.Printer
    Toml.Type.TOML Toml.Type.UValue Toml.Type.Value

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tomland-1.3.3.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tomland-1.3.3.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tomland-1.3.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tomland
hs-libraries:         HStomland-1.3.3.3-7bqNVFOAtTuDZxKEcBVEq
depends:
    base-4.18.2.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-L2Cc1YdcpYH9U2sZW5osde
    megaparsec-9.7.0-I0qZdfD2x7QA5TPaNUjmTK mtl-2.3.1
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48 text-2.0.2
    time-1.12.2 unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    validation-selective-0.2.0.0-4oq5uZqJfSY1VrVSIEbNkg

haddock-interfaces:   /usr/share/doc/haskell-tomland/html/tomland.haddock
haddock-html:         /usr/share/doc/haskell-tomland/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

