/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.languagetool.DetectedLanguage;
import org.languagetool.Language;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignLanguageChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForeignLanguageChecker.class);
    private static final float ERROR_THRESHOLD = 0.45f;
    private static final int MIN_SENTENCE_THRESHOLD = 3;
    private static final int MAX_SCORING_LANGUAGES = 5;
    public static final String NO_FOREIGN_LANG_DETECTED = "NO_FOREIGN_LANG_DETECTED";
    private final String languageShortCode;
    private final String sentence;
    private final long sentenceLength;
    private final List<String> preferredLanguages;

    public ForeignLanguageChecker(String languageShortCode, String sentence, Long sentenceLength, List<String> preferredLanguages) {
        this.languageShortCode = languageShortCode;
        this.sentence = sentence;
        this.sentenceLength = sentenceLength;
        this.preferredLanguages = Collections.unmodifiableList(preferredLanguages);
    }

    @NotNull
    public Map<String, Float> check(int matchesSoFar) throws IOException {
        LanguageIdentifier langIdent;
        float errorRatio = (float)matchesSoFar / (float)this.sentenceLength;
        if (this.sentenceLength >= 3L && errorRatio >= 0.45f && (langIdent = LanguageIdentifierService.INSTANCE.getInitialized()) != null) {
            List<DetectedLanguage> detectedLanguageScores = langIdent.getDetectedLanguageScores(this.sentence, Collections.emptyList(), this.preferredLanguages, true, 5);
            LinkedHashMap<String, Float> results = new LinkedHashMap<String, Float>(5);
            if (!detectedLanguageScores.isEmpty()) {
                for (int i = 0; i < detectedLanguageScores.size(); ++i) {
                    DetectedLanguage detectedLanguage = detectedLanguageScores.get(i);
                    Language language = detectedLanguage.getDetectedLanguage();
                    if (i == 0 && language.getShortCode().equals(this.languageShortCode)) {
                        return Collections.singletonMap(NO_FOREIGN_LANG_DETECTED, Float.valueOf(0.99f));
                    }
                    log.trace("Found '{}' sentence in '{}' text: '{}' with confidence {} from source '{}'", new Object[]{language.getShortCode(), this.languageShortCode, this.sentence, Float.valueOf(detectedLanguage.getDetectionConfidence()), detectedLanguage.getDetectionSource()});
                    results.put(language.getShortCode(), Float.valueOf(detectedLanguage.getDetectionConfidence()));
                }
                return results;
            }
            return Collections.singletonMap(NO_FOREIGN_LANG_DETECTED, Float.valueOf(0.99f));
        }
        return Collections.emptyMap();
    }
}

