/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public class GrReferenceListElementType<T extends GrReferenceList>
extends GrStubElementType<GrReferenceListStub, T> {
    public GrReferenceListElementType(String debugName) {
        super(debugName);
    }

    @NotNull
    public GrReferenceListStub createStub(@NotNull T psi, StubElement<?> parentStub) {
        if (psi == null) {
            GrReferenceListElementType.$$$reportNull$$$0(0);
        }
        ArrayList<String> refNames = new ArrayList<String>();
        for (GrCodeReferenceElement element : psi.getReferenceElementsGroovy()) {
            String name = GrStubUtils.getReferenceName(element);
            if (!StringUtil.isNotEmpty((String)name)) continue;
            refNames.add(name);
        }
        return new GrReferenceListStub(parentStub, this, ArrayUtilRt.toStringArray(refNames));
    }

    public void serialize(@NotNull GrReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            GrReferenceListElementType.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            GrReferenceListElementType.$$$reportNull$$$0(2);
        }
        GrStubUtils.writeStringArray(dataStream, stub.getBaseClasses());
    }

    @NotNull
    public GrReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            GrReferenceListElementType.$$$reportNull$$$0(3);
        }
        return new GrReferenceListStub(parentStub, this, GrStubUtils.readStringArray(dataStream));
    }

    @Override
    public void indexStub(@NotNull GrReferenceListStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            GrReferenceListElementType.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            GrReferenceListElementType.$$$reportNull$$$0(5);
        }
        for (String name : stub.getBaseClasses()) {
            if (name == null) continue;
            sink.occurrence(GrDirectInheritorsIndex.KEY, (Object)PsiNameHelper.getShortClassName((String)name));
        }
    }

    public T createPsi(@NotNull GrReferenceListStub stub) {
        if (stub == null) {
            GrReferenceListElementType.$$$reportNull$$$0(6);
        }
        throw new AssertionError();
    }

    public boolean isLeftBound() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

