/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

public class Node {
    Type type;
    Object payload;
    Object defaultPart;
    Node next;

    public Node(Type type, Object payload) {
        this.type = type;
        this.payload = payload;
    }

    public Node(Type type, Object payload, Object defaultPart) {
        this.type = type;
        this.payload = payload;
        this.defaultPart = defaultPart;
    }

    void append(Node newNode) {
        if (newNode == null) {
            return;
        }
        Node n15 = this;
        while (true) {
            if (n15.next == null) {
                n15.next = newNode;
                return;
            }
            n15 = n15.next;
        }
    }

    public String toString() {
        switch (this.type.ordinal()) {
            case 0: {
                return "Node{type=" + String.valueOf((Object)this.type) + ", payload='" + String.valueOf(this.payload) + "'}";
            }
            case 1: {
                StringBuilder payloadBuf = new StringBuilder();
                StringBuilder defaultPartBuf2 = new StringBuilder();
                if (this.defaultPart != null) {
                    this.recursive((Node)this.defaultPart, defaultPartBuf2);
                }
                this.recursive((Node)this.payload, payloadBuf);
                String r15 = "Node{type=" + String.valueOf((Object)this.type) + ", payload='" + payloadBuf.toString() + "'";
                if (this.defaultPart != null) {
                    r15 = r15 + ", defaultPart=" + defaultPartBuf2.toString();
                }
                r15 = r15 + "}";
                return r15;
            }
        }
        return null;
    }

    public void dump() {
        System.out.print(this.toString());
        System.out.print(" -> ");
        if (this.next != null) {
            this.next.dump();
        } else {
            System.out.print(" null");
        }
    }

    void recursive(Node n15, StringBuilder sb5) {
        Node c15 = n15;
        while (c15 != null) {
            sb5.append(c15.toString()).append(" --> ");
            c15 = c15.next;
        }
        sb5.append("null ");
    }

    public void setNext(Node n15) {
        this.next = n15;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        Node node = (Node)o15;
        if (this.type != node.type) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(node.payload) : node.payload != null) {
            return false;
        }
        if (this.defaultPart != null ? !this.defaultPart.equals(node.defaultPart) : node.defaultPart != null) {
            return false;
        }
        return !(this.next != null ? !this.next.equals(node.next) : node.next != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.defaultPart != null ? this.defaultPart.hashCode() : 0);
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        return result;
    }

    static enum Type {
        LITERAL,
        VARIABLE;

    }
}

