/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.util.ByteInput;
import java.io.UTFDataFormatException;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(ByteInput in4, char[] out) throws UTFDataFormatException {
        int s15 = 0;
        while (true) {
            int b15;
            char a15;
            if ((a15 = (char)(in4.readByte() & 0xFF)) == '\u0000') {
                return new String(out, 0, s15);
            }
            out[s15] = a15;
            if (a15 < '\u0080') {
                ++s15;
                continue;
            }
            if ((a15 & 0xE0) == 192) {
                b15 = in4.readByte() & 0xFF;
                if ((b15 & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s15++] = (char)((a15 & 0x1F) << 6 | b15 & 0x3F);
                continue;
            }
            if ((a15 & 0xF0) != 224) break;
            b15 = in4.readByte() & 0xFF;
            int c15 = in4.readByte() & 0xFF;
            if ((b15 & 0xC0) != 128 || (c15 & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s15++] = (char)((a15 & 0xF) << 12 | (b15 & 0x3F) << 6 | c15 & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String s15, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s15.length();
        for (int i15 = 0; i15 < length; ++i15) {
            char ch4 = s15.charAt(i15);
            result = ch4 != '\u0000' && ch4 <= '\u007f' ? ++result : (ch4 <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s15) {
        int length = s15.length();
        for (int i15 = 0; i15 < length; ++i15) {
            char ch4 = s15.charAt(i15);
            if (ch4 != '\u0000' && ch4 <= '\u007f') {
                dst[offset++] = (byte)ch4;
                continue;
            }
            if (ch4 <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch4 >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch4);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch4 >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch4 >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch4);
        }
    }

    public static byte[] encode(String s15) throws UTFDataFormatException {
        int utfCount = (int)Mutf8.countBytes(s15, true);
        byte[] result = new byte[utfCount];
        Mutf8.encode(result, 0, s15);
        return result;
    }
}

