/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.DeviceGroup;
import com.android.bundle.DeviceSelector;
import com.android.bundle.DeviceTier;
import com.android.bundle.DeviceTierConfig;
import com.android.bundle.DeviceTierSet;
import com.android.bundle.UserCountrySet;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DeviceTierConfigValidator {
    private static final String COUNTRY_SET_NAME_REGEX_STRING = "^[a-zA-Z][a-zA-Z0-9_]*$";
    private static final String COUNTRY_CODE_REGEX_STRING = "^[A-Z]{2}$";
    private static final Pattern COUNTRY_SET_NAME_REGEX = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    private static final Pattern COUNTRY_CODE_REGEX = Pattern.compile("^[A-Z]{2}$");

    private DeviceTierConfigValidator() {
    }

    public static void validateDeviceTierConfig(DeviceTierConfig deviceTierConfig) {
        if (deviceTierConfig.getUserCountrySetsList().isEmpty() && deviceTierConfig.getDeviceGroupsList().isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("The device tier config must contain at least one group or user country set.").build();
        }
        DeviceTierConfigValidator.validateUserCountrySets(deviceTierConfig.getUserCountrySetsList());
        DeviceTierConfigValidator.validateGroups(deviceTierConfig.getDeviceGroupsList());
        DeviceTierConfigValidator.validateTiers(deviceTierConfig.getDeviceTierSet(), deviceTierConfig.getDeviceGroupsList());
    }

    public static void validateCountryCode(String countryCode) {
        if (!COUNTRY_CODE_REGEX.matcher(countryCode).matches()) {
            throw CommandExecutionException.builder().withInternalMessage("Country code should match the regex '%s', but found '%s'.", COUNTRY_CODE_REGEX, countryCode).build();
        }
    }

    private static void validateUserCountrySets(List<UserCountrySet> userCountrySets) {
        userCountrySets.forEach(DeviceTierConfigValidator::validateUserCountrySet);
        DeviceTierConfigValidator.validateCountrySetNamesAreUnique(userCountrySets);
        DeviceTierConfigValidator.validateCountryCodesAreUnique(userCountrySets);
    }

    private static void validateCountrySetNamesAreUnique(List<UserCountrySet> userCountrySets) {
        ImmutableSet duplicateNames = userCountrySets.stream().map(UserCountrySet::getName).collect(CollectorUtils.groupingByDeterministic(Function.identity(), Collectors.counting())).entrySet().stream().filter(e15 -> (Long)e15.getValue() > 1L).map(e15 -> (String)e15.getKey()).collect(ImmutableSet.toImmutableSet());
        if (!duplicateNames.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("Country set names should be unique. Found multiple country sets with these names: %s.", duplicateNames).build();
        }
    }

    private static void validateCountryCodesAreUnique(List<UserCountrySet> userCountrySets) {
        ImmutableSet duplicateCountryCodes = userCountrySets.stream().flatMap(userCountrySet -> userCountrySet.getCountryCodesList().stream()).collect(CollectorUtils.groupingByDeterministic(Function.identity(), Collectors.counting())).entrySet().stream().filter(e15 -> (Long)e15.getValue() > 1L).map(e15 -> (String)e15.getKey()).collect(ImmutableSet.toImmutableSet());
        if (!duplicateCountryCodes.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("A country code can belong to only one country set. Found multiple occurrences of these country codes: %s.", duplicateCountryCodes.toString()).build();
        }
    }

    private static void validateUserCountrySet(UserCountrySet userCountrySet) {
        DeviceTierConfigValidator.validateCountrySetName(userCountrySet.getName());
        if (userCountrySet.getCountryCodesList().isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("Country set '%s' must specify at least one country code.", userCountrySet.getName()).build();
        }
        userCountrySet.getCountryCodesList().forEach(DeviceTierConfigValidator::validateCountryCode);
    }

    private static void validateCountrySetName(String countrySetName) {
        if (countrySetName.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("Country Sets must specify a name.").build();
        }
        if (!COUNTRY_SET_NAME_REGEX.matcher(countrySetName).matches()) {
            throw CommandExecutionException.builder().withInternalMessage("Country set name should match the regex '%s', but found '%s'.", COUNTRY_SET_NAME_REGEX_STRING, countrySetName).build();
        }
    }

    private static void validateGroups(List<DeviceGroup> deviceGroups) {
        for (DeviceGroup deviceGroup : deviceGroups) {
            if (deviceGroup.getName().isEmpty()) {
                throw CommandExecutionException.builder().withInternalMessage("Device groups must specify a name.").build();
            }
            DeviceTierConfigValidator.validateDeviceSelectors(deviceGroup.getDeviceSelectorsList(), deviceGroup.getName());
        }
    }

    private static void validateDeviceSelectors(List<DeviceSelector> deviceSelectors, String groupName) {
        if (deviceSelectors.isEmpty()) {
            throw CommandExecutionException.builder().withInternalMessage("Device group '%s' must specify at least one selector.", groupName).build();
        }
    }

    private static void validateTiers(DeviceTierSet deviceTierSet, List<DeviceGroup> deviceGroups) {
        if (deviceTierSet.getDeviceTiersCount() == 0) {
            return;
        }
        ImmutableSet deviceGroupNames = deviceGroups.stream().map(DeviceGroup::getName).collect(ImmutableSet.toImmutableSet());
        DeviceTierConfigValidator.validateTierLevels(deviceTierSet);
        for (DeviceTier deviceTier : deviceTierSet.getDeviceTiersList()) {
            if (deviceTier.getDeviceGroupNamesList().isEmpty()) {
                throw CommandExecutionException.builder().withInternalMessage("Tier %d must specify at least one group", deviceTier.getLevel()).build();
            }
            for (String deviceGroupName : deviceTier.getDeviceGroupNamesList()) {
                if (deviceGroupNames.contains(deviceGroupName)) continue;
                throw CommandExecutionException.builder().withInternalMessage("Tier %d must specify existing groups, but found undefined group '%s'.", deviceTier.getLevel(), deviceGroupName).build();
            }
        }
    }

    private static void validateTierLevels(DeviceTierSet deviceTierSet) {
        ImmutableListMultimap<Integer, DeviceTier> tiersByLevel = deviceTierSet.getDeviceTiersList().stream().collect(ImmutableListMultimap.toImmutableListMultimap(DeviceTier::getLevel, x15 -> x15));
        int minTierLevel = (Integer)Collections.min(tiersByLevel.keySet());
        int maxTierLevel = (Integer)Collections.max(tiersByLevel.keySet());
        if (minTierLevel <= 0) {
            throw CommandExecutionException.builder().withInternalMessage("Each tier must specify a positive level, but found %d.", minTierLevel).build();
        }
        for (int level = 1; level <= maxTierLevel; ++level) {
            if (!tiersByLevel.containsKey(level)) {
                throw CommandExecutionException.builder().withInternalMessage("Tier %d is undefined. You should define all tiers between 1 and your total number of tiers.", level).build();
            }
            if (tiersByLevel.get((Object)level).size() <= 1) continue;
            throw CommandExecutionException.builder().withInternalMessage("Tier %d should be uniquely defined, but it was defined %d times.", level, tiersByLevel.get((Object)level).size()).build();
        }
    }
}

