/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.VersionMap;
import com.android.tools.smali.dexlib2.dexbacked.CDexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.raw.CdexHeaderItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.MapItem;
import com.android.tools.smali.dexlib2.dexbacked.raw.SectionAnnotator;
import com.android.tools.smali.dexlib2.dexbacked.raw.util.DexAnnotator;
import com.android.tools.smali.dexlib2.util.AnnotatedBytes;
import com.android.tools.smali.util.StringUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HeaderItem {
    public static final int ITEM_SIZE = 112;
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 120, 10, 0, 0, 0, 0};
    public static final int LITTLE_ENDIAN_TAG = 305419896;
    public static final int BIG_ENDIAN_TAG = 2018915346;
    public static final int CHECKSUM_OFFSET = 8;
    public static final int CHECKSUM_DATA_START_OFFSET = 12;
    public static final int SIGNATURE_OFFSET = 12;
    public static final int SIGNATURE_SIZE = 20;
    public static final int SIGNATURE_DATA_START_OFFSET = 32;
    public static final int FILE_SIZE_OFFSET = 32;
    public static final int HEADER_SIZE_OFFSET = 36;
    public static final int ENDIAN_TAG_OFFSET = 40;
    public static final int MAP_OFFSET = 52;
    public static final int STRING_COUNT_OFFSET = 56;
    public static final int STRING_START_OFFSET = 60;
    public static final int TYPE_COUNT_OFFSET = 64;
    public static final int TYPE_START_OFFSET = 68;
    public static final int PROTO_COUNT_OFFSET = 72;
    public static final int PROTO_START_OFFSET = 76;
    public static final int FIELD_COUNT_OFFSET = 80;
    public static final int FIELD_START_OFFSET = 84;
    public static final int METHOD_COUNT_OFFSET = 88;
    public static final int METHOD_START_OFFSET = 92;
    public static final int CLASS_COUNT_OFFSET = 96;
    public static final int CLASS_START_OFFSET = 100;
    public static final int DATA_SIZE_OFFSET = 104;
    public static final int DATA_START_OFFSET = 108;
    public static final int CONTAINER_SIZE_OFFSET = 112;
    public static final int CONTAINER_OFF_OFFSET = 116;
    @Nonnull
    private DexBackedDexFile dexFile;

    public HeaderItem(@Nonnull DexBackedDexFile dexFile) {
        this.dexFile = dexFile;
    }

    public int getChecksum() {
        return this.dexFile.getBuffer().readSmallUint(8);
    }

    @Nonnull
    public byte[] getSignature() {
        return this.dexFile.getBuffer().readByteRange(12, 20);
    }

    public int getMapOffset() {
        return this.dexFile.getBuffer().readSmallUint(52);
    }

    public int getHeaderSize() {
        return this.dexFile.getBuffer().readSmallUint(36);
    }

    public int getStringCount() {
        return this.dexFile.getBuffer().readSmallUint(56);
    }

    public int getStringOffset() {
        return this.dexFile.getBuffer().readSmallUint(60);
    }

    public int getTypeCount() {
        return this.dexFile.getBuffer().readSmallUint(64);
    }

    public int getTypeOffset() {
        return this.dexFile.getBuffer().readSmallUint(68);
    }

    public int getProtoCount() {
        return this.dexFile.getBuffer().readSmallUint(72);
    }

    public int getProtoOffset() {
        return this.dexFile.getBuffer().readSmallUint(76);
    }

    public int getFieldCount() {
        return this.dexFile.getBuffer().readSmallUint(80);
    }

    public int getFieldOffset() {
        return this.dexFile.getBuffer().readSmallUint(84);
    }

    public int getMethodCount() {
        return this.dexFile.getBuffer().readSmallUint(88);
    }

    public int getMethodOffset() {
        return this.dexFile.getBuffer().readSmallUint(92);
    }

    public int getClassCount() {
        return this.dexFile.getBuffer().readSmallUint(96);
    }

    public int getClassOffset() {
        return this.dexFile.getBuffer().readSmallUint(100);
    }

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "header_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int startOffset = out.getCursor();
                StringBuilder magicBuilder = new StringBuilder();
                for (int i15 = 0; i15 < 8; ++i15) {
                    magicBuilder.append((char)this.dexFile.getBuffer().readUbyte(startOffset + i15));
                }
                out.annotate(8, "magic: %s", StringUtils.escapeString(magicBuilder.toString()));
                out.annotate(4, "checksum", new Object[0]);
                out.annotate(20, "signature", new Object[0]);
                out.annotate(4, "file_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                int headerSize = this.dexFile.getBuffer().readInt(out.getCursor());
                out.annotate(4, "header_size: %d", headerSize);
                int endianTag = this.dexFile.getBuffer().readInt(out.getCursor());
                out.annotate(4, "endian_tag: 0x%x (%s)", endianTag, HeaderItem.getEndianText(endianTag));
                out.annotate(4, "link_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "link_offset: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "map_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "string_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "string_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "type_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "type_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "proto_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "proto_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "field_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "field_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "method_ids_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "method_ids_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "class_defs_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "class_defs_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "data_size: %d", this.dexFile.getBuffer().readInt(out.getCursor()));
                out.annotate(4, "data_off: 0x%x", this.dexFile.getBuffer().readInt(out.getCursor()));
                if (this.annotator.dexFile instanceof CDexBackedDexFile) {
                    CdexHeaderItem.annotateCdexHeaderFields(out, this.dexFile.getBuffer());
                }
                if (headerSize > 112) {
                    out.annotateTo(headerSize, "header padding", new Object[0]);
                }
            }
        };
    }

    private static String getEndianText(int endianTag) {
        if (endianTag == 305419896) {
            return "Little Endian";
        }
        if (endianTag == 2018915346) {
            return "Big Endian";
        }
        return "Invalid";
    }

    public static byte[] getMagicForApi(int api) {
        return HeaderItem.getMagicForDexVersion(VersionMap.mapApiToDexVersion(api));
    }

    public static byte[] getMagicForDexVersion(int dexVersion) {
        byte[] magic = (byte[])MAGIC_VALUE.clone();
        if (dexVersion < 0 || dexVersion > 999) {
            throw new IllegalArgumentException("dexVersion must be within [0, 999]");
        }
        for (int i15 = 6; i15 >= 4; --i15) {
            int digit = dexVersion % 10;
            magic[i15] = (byte)(48 + digit);
            dexVersion /= 10;
        }
        return magic;
    }

    public static boolean verifyMagic(byte[] buf, int offset) {
        int i15;
        if (buf.length - offset < 8) {
            return false;
        }
        for (i15 = 0; i15 < 4; ++i15) {
            if (buf[offset + i15] == MAGIC_VALUE[i15]) continue;
            return false;
        }
        for (i15 = 4; i15 < 7; ++i15) {
            if (buf[offset + i15] >= 48 && buf[offset + i15] <= 57) continue;
            return false;
        }
        return buf[offset + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] buf, int offset) {
        if (!HeaderItem.verifyMagic(buf, offset)) {
            return -1;
        }
        return HeaderItem.getVersionUnchecked(buf, offset);
    }

    private static int getVersionUnchecked(byte[] buf, int offset) {
        int version = (buf[offset + 4] - 48) * 100;
        version += (buf[offset + 5] - 48) * 10;
        return version += buf[offset + 6] - 48;
    }

    public static boolean isSupportedDexVersion(int version) {
        return VersionMap.mapDexVersionToApi(version) != -1;
    }

    public static int getEndian(byte[] buf, int offset) {
        DexBuffer bdb = new DexBuffer(buf);
        return bdb.readInt(offset + 40);
    }
}

