/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.UIManager;

@FlatStylingSupport.StyleableField(cls=FlatAbstractIcon.class, key="closeScale", fieldName="scale")
public class FlatTabbedPaneCloseIcon
extends FlatAbstractIcon
implements FlatStylingSupport.StyleableObject {
    @FlatStylingSupport.Styleable
    protected Dimension closeSize = UIManager.getDimension("TabbedPane.closeSize");
    @FlatStylingSupport.Styleable
    protected int closeArc = UIManager.getInt("TabbedPane.closeArc");
    @FlatStylingSupport.Styleable
    protected float closeCrossPlainSize = FlatUIUtils.getUIFloat("TabbedPane.closeCrossPlainSize", 7.5f);
    @FlatStylingSupport.Styleable
    protected float closeCrossFilledSize = FlatUIUtils.getUIFloat("TabbedPane.closeCrossFilledSize", this.closeCrossPlainSize);
    @FlatStylingSupport.Styleable
    protected float closeCrossLineWidth = FlatUIUtils.getUIFloat("TabbedPane.closeCrossLineWidth", 1.0f);
    @FlatStylingSupport.Styleable
    protected Color closeBackground = UIManager.getColor("TabbedPane.closeBackground");
    @FlatStylingSupport.Styleable
    protected Color closeForeground = UIManager.getColor("TabbedPane.closeForeground");
    @FlatStylingSupport.Styleable
    protected Color closeHoverBackground = UIManager.getColor("TabbedPane.closeHoverBackground");
    @FlatStylingSupport.Styleable
    protected Color closeHoverForeground = UIManager.getColor("TabbedPane.closeHoverForeground");
    @FlatStylingSupport.Styleable
    protected Color closePressedBackground = UIManager.getColor("TabbedPane.closePressedBackground");
    @FlatStylingSupport.Styleable
    protected Color closePressedForeground = UIManager.getColor("TabbedPane.closePressedForeground");

    public FlatTabbedPaneCloseIcon() {
        super(16, 16, null);
    }

    @Override
    protected void paintIcon(Component c15, Graphics2D g15) {
        Color bg5 = FlatButtonUI.buttonStateColor(c15, this.closeBackground, null, null, this.closeHoverBackground, this.closePressedBackground);
        if (bg5 != null) {
            g15.setColor(FlatUIUtils.deriveColor(bg5, c15.getBackground()));
            g15.fillRoundRect((this.width - this.closeSize.width) / 2, (this.height - this.closeSize.height) / 2, this.closeSize.width, this.closeSize.height, this.closeArc, this.closeArc);
        }
        Color fg5 = FlatButtonUI.buttonStateColor(c15, this.closeForeground, null, null, this.closeHoverForeground, this.closePressedForeground);
        g15.setColor(FlatUIUtils.deriveColor(fg5, c15.getForeground()));
        float mx4 = (float)this.width / 2.0f;
        float my4 = (float)this.height / 2.0f;
        float r15 = (bg5 != null ? this.closeCrossFilledSize : this.closeCrossPlainSize) / 2.0f;
        Path2D.Float path = new Path2D.Float(0, 4);
        ((Path2D)path).moveTo(mx4 - r15, my4 - r15);
        ((Path2D)path).lineTo(mx4 + r15, my4 + r15);
        ((Path2D)path).moveTo(mx4 - r15, my4 + r15);
        ((Path2D)path).lineTo(mx4 + r15, my4 - r15);
        g15.setStroke(new BasicStroke(this.closeCrossLineWidth));
        g15.draw(path);
    }
}

