/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToggleButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class FlatButtonBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("Button.arc");
    protected Color endBorderColor = UIManager.getColor("Button.endBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("Button.hoverBorderColor");
    @FlatStylingSupport.Styleable
    protected Color pressedBorderColor = UIManager.getColor("Button.pressedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color selectedBorderColor = UIManager.getColor("Button.selectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBorderColor = UIManager.getColor("Button.disabledSelectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedSelectedBorderColor = UIManager.getColor("Button.focusedSelectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverSelectedBorderColor = UIManager.getColor("Button.hoverSelectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color pressedSelectedBorderColor = UIManager.getColor("Button.pressedSelectedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float defaultBorderWidth = FlatUIUtils.getUIFloat("Button.default.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBorderColor = FlatUIUtils.getUIColor("Button.default.startBorderColor", "Button.default.borderColor");
    protected Color defaultEndBorderColor = UIManager.getColor("Button.default.endBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBorderColor = UIManager.getColor("Button.default.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusColor = UIManager.getColor("Button.default.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBorderColor = UIManager.getColor("Button.default.hoverBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedBorderColor = UIManager.getColor("Button.default.pressedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float toolbarFocusWidth = FlatUIUtils.getUIFloat("Button.toolbar.focusWidth", 1.5f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarFocusColor = UIManager.getColor("Button.toolbar.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarMargin = UIManager.getInsets("Button.toolbar.margin");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarSpacingInsets = UIManager.getInsets("Button.toolbar.spacingInsets");

    public FlatButtonBorder() {
        this.innerFocusWidth = FlatUIUtils.getUIFloat("Button.innerFocusWidth", this.innerFocusWidth);
        this.borderWidth = FlatUIUtils.getUIFloat("Button.borderWidth", this.borderWidth);
        this.borderColor = FlatUIUtils.getUIColor("Button.startBorderColor", "Button.borderColor");
        this.disabledBorderColor = UIManager.getColor("Button.disabledBorderColor");
        this.focusedBorderColor = UIManager.getColor("Button.focusedBorderColor");
    }

    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        if (!(!FlatButtonUI.isContentAreaFilled(c15) || FlatButtonUI.isToolBarButton(c15) || FlatButtonUI.isBorderlessButton(c15) && !FlatUIUtils.isPermanentFocusOwner(c15) || FlatButtonUI.isHelpButton(c15) || FlatToggleButtonUI.isTabButton(c15))) {
            super.paintBorder(c15, g15, x15, y15, width, height);
        } else if (FlatButtonUI.isToolBarButton(c15) && this.isFocused(c15)) {
            this.paintToolBarFocus(c15, g15, x15, y15, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintToolBarFocus(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            float focusWidth = UIScale.scale(this.toolbarFocusWidth);
            float arc = UIScale.scale((float)this.getArc(c15));
            Color outlineColor = this.getOutlineColor(c15);
            Insets spacing = UIScale.scale(this.toolbarSpacingInsets);
            Color color = outlineColor != null ? outlineColor : this.getFocusColor(c15);
            FlatUIUtils.paintOutlinedComponent(g25, x15 += spacing.left, y15 += spacing.top, width -= spacing.left + spacing.right, height -= spacing.top + spacing.bottom, 0.0f, 0.0f, 0.0f, focusWidth, arc, null, color, null);
        }
        finally {
            g25.dispose();
        }
    }

    @Override
    protected Color getFocusColor(Component c15) {
        return this.toolbarFocusColor != null && FlatButtonUI.isToolBarButton(c15) ? this.toolbarFocusColor : (FlatButtonUI.isDefaultButton(c15) ? this.defaultFocusColor : super.getFocusColor(c15));
    }

    @Override
    protected boolean isFocused(Component c15) {
        return FlatButtonUI.isFocusPainted(c15) && super.isFocused(c15);
    }

    @Override
    protected Paint getBorderColor(Component c15) {
        Color endBg;
        boolean selected;
        boolean def = FlatButtonUI.isDefaultButton(c15);
        boolean bl4 = selected = c15 instanceof AbstractButton && ((AbstractButton)c15).isSelected();
        Paint color = FlatButtonUI.buttonStateColor(c15, def ? this.defaultBorderColor : (selected && this.selectedBorderColor != null ? this.selectedBorderColor : this.borderColor), selected && this.disabledSelectedBorderColor != null ? this.disabledSelectedBorderColor : this.disabledBorderColor, def ? this.defaultFocusedBorderColor : (selected && this.focusedSelectedBorderColor != null ? this.focusedSelectedBorderColor : this.focusedBorderColor), def ? this.defaultHoverBorderColor : (selected && this.hoverSelectedBorderColor != null ? this.hoverSelectedBorderColor : this.hoverBorderColor), def ? this.defaultPressedBorderColor : (selected && this.pressedSelectedBorderColor != null ? this.pressedSelectedBorderColor : this.pressedBorderColor));
        Color startBg = def ? this.defaultBorderColor : this.borderColor;
        Color color2 = endBg = def ? this.defaultEndBorderColor : this.endBorderColor;
        if (color == startBg && endBg != null && !startBg.equals(endBg)) {
            color = new GradientPaint(0.0f, 0.0f, startBg, 0.0f, c15.getHeight(), endBg);
        }
        return color;
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        if (FlatButtonUI.isToolBarButton(c15)) {
            Insets margin = c15 instanceof AbstractButton ? ((AbstractButton)c15).getMargin() : null;
            FlatUIUtils.setInsets(insets, UIScale.scale(FlatUIUtils.addInsets(this.toolbarSpacingInsets, margin != null && !(margin instanceof UIResource) ? margin : this.toolbarMargin)));
        } else {
            insets = super.getBorderInsets(c15, insets);
            if (FlatButtonUI.isIconOnlyOrSingleCharacterButton(c15) && ((AbstractButton)c15).getMargin() instanceof UIResource) {
                insets.left = insets.right = Math.min(insets.top, insets.bottom);
            }
        }
        return insets;
    }

    @Override
    protected int getFocusWidth(Component c15) {
        return FlatToggleButtonUI.isTabButton(c15) ? 0 : super.getFocusWidth(c15);
    }

    @Override
    protected float getBorderWidth(Component c15) {
        return FlatButtonUI.isDefaultButton(c15) ? this.defaultBorderWidth : this.borderWidth;
    }

    @Override
    protected int getArc(Component c15) {
        if (this.isCellEditor(c15)) {
            return 0;
        }
        switch (FlatButtonUI.getButtonType(c15)) {
            case 0: {
                return 0;
            }
            case 1: {
                return Short.MAX_VALUE;
            }
        }
        return this.arc;
    }
}

