/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry.util;

import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;

public final class ReversePathIterator
implements PathIterator {
    private final int windingRule;
    private final double[] coordinates;
    private final int[] segmentTypes;
    private int coordIndex = 0;
    private int segmentIndex = 0;

    public ReversePathIterator(PathIterator original) {
        this(original, original.getWindingRule());
    }

    public ReversePathIterator(PathIterator original, int windingRule) {
        this.windingRule = windingRule;
        double[] coords = new double[16];
        int coordPos = 0;
        int[] segTypes = new int[8];
        int segPos = 0;
        boolean first = true;
        double[] temp = new double[6];
        while (!original.isDone()) {
            int copy;
            if (segPos == segTypes.length) {
                int[] dummy = new int[2 * segPos];
                System.arraycopy(segTypes, 0, dummy, 0, segPos);
                segTypes = dummy;
            }
            int n15 = segPos++;
            int n16 = original.currentSegment(temp);
            segTypes[n15] = n16;
            int segType = n16;
            if (first) {
                if (segType != 0) {
                    throw new IllegalPathStateException("missing initial moveto in path definition");
                }
                first = false;
            }
            if ((copy = ReversePathIterator.coordinatesForSegmentType(segType)) > 0) {
                if (coordPos + copy > coords.length) {
                    double[] dummy = new double[coords.length * 2];
                    System.arraycopy(coords, 0, dummy, 0, coords.length);
                    coords = dummy;
                }
                for (int c15 = 0; c15 < copy; ++c15) {
                    coords[coordPos++] = temp[c15];
                }
            }
            original.next();
        }
        this.coordinates = new double[coordPos];
        for (int p15 = coordPos / 2 - 1; p15 >= 0; --p15) {
            this.coordinates[2 * p15] = coords[coordPos - 2 * p15 - 2];
            this.coordinates[2 * p15 + 1] = coords[coordPos - 2 * p15 - 1];
        }
        this.segmentTypes = new int[segPos];
        if (segPos > 0) {
            boolean pendingClose = false;
            int sr4 = 0;
            this.segmentTypes[sr4++] = 0;
            block7: for (int s15 = segPos - 1; s15 > 0; --s15) {
                switch (segTypes[s15]) {
                    case 0: {
                        if (pendingClose) {
                            pendingClose = false;
                            this.segmentTypes[sr4++] = 4;
                        }
                        this.segmentTypes[sr4++] = 0;
                        continue block7;
                    }
                    case 4: {
                        pendingClose = true;
                        continue block7;
                    }
                    default: {
                        this.segmentTypes[sr4++] = segTypes[s15];
                    }
                }
            }
            if (pendingClose) {
                this.segmentTypes[sr4] = 4;
            }
        }
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    private static int coordinatesForSegmentType(int segtype) {
        switch (segtype) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public void next() {
        this.coordIndex += ReversePathIterator.coordinatesForSegmentType(this.segmentTypes[this.segmentIndex++]);
    }

    @Override
    public boolean isDone() {
        return this.segmentIndex >= this.segmentTypes.length;
    }

    @Override
    public int currentSegment(double[] coords) {
        int segmentType = this.segmentTypes[this.segmentIndex];
        int copy = ReversePathIterator.coordinatesForSegmentType(segmentType);
        if (copy > 0) {
            System.arraycopy(this.coordinates, this.coordIndex, coords, 0, copy);
        }
        return segmentType;
    }

    @Override
    public int currentSegment(float[] coords) {
        int segmentType = this.segmentTypes[this.segmentIndex];
        int copy = ReversePathIterator.coordinatesForSegmentType(segmentType);
        if (copy > 0) {
            for (int c15 = 0; c15 < copy; ++c15) {
                coords[c15] = (float)this.coordinates[this.coordIndex + c15];
            }
        }
        return segmentType;
    }
}

