/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.tiff;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.tiff.IFD;
import com.twelvemonkeys.imageio.metadata.tiff.Rational;
import com.twelvemonkeys.imageio.metadata.tiff.TIFF;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFDirectory;
import com.twelvemonkeys.imageio.metadata.tiff.TIFFEntry;
import com.twelvemonkeys.imageio.metadata.tiff.Unknown;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public final class TIFFReader
extends MetadataReader {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.metadata.tiff.debug"));
    private static final Collection<Integer> VALID_TOP_LEVEL_IFDS = Collections.unmodifiableCollection(Arrays.asList(330, 34665, 34853));
    private static final Map<Integer, Collection<Integer>> VALID_SUB_IFDS = TIFFReader.createSubIFDMap();
    private final Set<Long> parsedIFDs = new TreeSet<Long>();
    private long inputLength;
    private boolean longOffsets;
    private int offsetSize;

    private static Map<Integer, Collection<Integer>> createSubIFDMap() {
        HashMap<Integer, Collection<Integer>> hashMap = new HashMap<Integer, Collection<Integer>>(){

            @Override
            public Collection<Integer> get(Object object) {
                Set<Integer> set = (Set<Integer>)super.get(object);
                return set != null ? set : Collections.emptySet();
            }
        };
        hashMap.put(330, Collections.singleton(330));
        hashMap.put(34665, Collections.singleton(40965));
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Directory read(ImageInputStream imageInputStream) throws IOException {
        Validate.notNull(imageInputStream, "input");
        byte[] byArray = new byte[2];
        imageInputStream.readFully(byArray);
        if (byArray[0] == 73 && byArray[1] == 73) {
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (byArray[0] == 77 && byArray[1] == 77) {
            imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            throw new IIOException(String.format("Invalid TIFF byte order mark '%s', expected: 'II' or 'MM'", StringUtil.decode(byArray, 0, byArray.length, "ASCII")));
        }
        int n15 = imageInputStream.readUnsignedShort();
        if (n15 == 42) {
            this.longOffsets = false;
            this.offsetSize = 4;
        } else if (n15 == 43) {
            this.longOffsets = true;
            this.offsetSize = 8;
            int n16 = imageInputStream.readUnsignedShort();
            if (n16 != 8) {
                throw new IIOException(String.format("Unexpected BigTIFF offset size: %04x, expected: %04x", n16, 8));
            }
            int n17 = imageInputStream.readUnsignedShort();
            if (n17 != 0) {
                throw new IIOException(String.format("Unexpected BigTIFF padding: %04x, expected: %04x", n17, 0));
            }
        } else {
            throw new IIOException(String.format("Wrong TIFF magic in input data: %04x, expected: %04x", n15, 42));
        }
        this.inputLength = imageInputStream.length();
        return this.readLinkedIFDs(imageInputStream);
    }

    private TIFFDirectory readLinkedIFDs(ImageInputStream imageInputStream) throws IOException {
        long l15 = this.readOffset(imageInputStream);
        ArrayList<IFD> arrayList = new ArrayList<IFD>();
        while (l15 != 0L) {
            try {
                if (this.inputLength > 0L && l15 >= this.inputLength || !this.isValidOffset(imageInputStream, l15) || !this.parsedIFDs.add(l15)) {
                    if (!DEBUG) break;
                    System.err.println("Bad IFD offset: " + l15);
                    break;
                }
                arrayList.add(this.readIFD(imageInputStream, l15, VALID_TOP_LEVEL_IFDS));
                l15 = this.readOffset(imageInputStream);
            }
            catch (EOFException eOFException) {
                l15 = 0L;
            }
        }
        return new TIFFDirectory((Collection<? extends Directory>)arrayList);
    }

    private long readOffset(ImageInputStream imageInputStream) throws IOException {
        return this.longOffsets ? imageInputStream.readLong() : imageInputStream.readUnsignedInt();
    }

    private IFD readIFD(ImageInputStream imageInputStream, long l15, Collection<Integer> collection) throws IOException {
        imageInputStream.seek(l15);
        long l16 = this.readEntryCount(imageInputStream);
        ArrayList<TIFFEntry> arrayList = new ArrayList<TIFFEntry>();
        int n15 = 0;
        while ((long)n15 < l16) {
            block3: {
                try {
                    TIFFEntry tIFFEntry = this.readEntry(imageInputStream);
                    if (tIFFEntry == null) break block3;
                    arrayList.add(tIFFEntry);
                }
                catch (IIOException iIOException) {
                    if (!DEBUG) break;
                    iIOException.printStackTrace();
                    break;
                }
            }
            ++n15;
        }
        this.readSubIFDs(imageInputStream, arrayList, collection);
        return new IFD(arrayList);
    }

    private long readEntryCount(ImageInputStream imageInputStream) throws IOException {
        return this.longOffsets ? imageInputStream.readLong() : (long)imageInputStream.readUnsignedShort();
    }

    private void readSubIFDs(ImageInputStream imageInputStream, List<TIFFEntry> list2, Collection<Integer> collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        long l15 = imageInputStream.getStreamPosition();
        int n15 = list2.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            TIFFEntry tIFFEntry = list2.get(i15);
            int n16 = (Integer)tIFFEntry.getIdentifier();
            if (!collection.contains(n16)) continue;
            try {
                long[] lArray = this.getPointerOffsets(tIFFEntry);
                ArrayList<IFD> arrayList = new ArrayList<IFD>(lArray.length);
                for (long l16 : lArray) {
                    try {
                        if (this.inputLength > 0L && l16 >= this.inputLength || !this.isValidOffset(imageInputStream, l16) || !this.parsedIFDs.add(l16)) {
                            if (!DEBUG) break;
                            System.err.println("Bad IFD offset: " + l16);
                            break;
                        }
                        arrayList.add(this.readIFD(imageInputStream, l16, VALID_SUB_IFDS.get(n16)));
                    }
                    catch (EOFException eOFException) {
                        if (!DEBUG) continue;
                        eOFException.printStackTrace();
                    }
                }
                if (arrayList.size() == 1) {
                    list2.set(i15, new TIFFEntry(n16, tIFFEntry.getType(), arrayList.get(0)));
                    continue;
                }
                if (arrayList.isEmpty()) continue;
                list2.set(i15, new TIFFEntry(n16, tIFFEntry.getType(), arrayList.toArray(new IFD[0])));
                continue;
            }
            catch (IIOException iIOException) {
                if (!DEBUG) continue;
                System.err.println("Error parsing sub-IFD: " + n16);
                iIOException.printStackTrace();
            }
        }
        imageInputStream.seek(l15);
    }

    private long[] getPointerOffsets(Entry entry) throws IIOException {
        long[] lArray;
        Object object = entry.getValue();
        if (object instanceof Byte) {
            lArray = new long[]{(Byte)object & 0xFF};
        } else if (object instanceof Short) {
            lArray = new long[]{(Short)object & 0xFFFF};
        } else if (object instanceof Integer) {
            lArray = new long[]{(long)((Integer)object).intValue() & 0xFFFFFFFFL};
        } else if (object instanceof Long) {
            lArray = new long[]{(Long)object};
        } else if (object instanceof long[]) {
            lArray = (long[])object;
        } else {
            throw new IIOException(String.format("Unknown pointer type: %s", object != null ? object.getClass() : null));
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIFFEntry readEntry(ImageInputStream imageInputStream) throws IOException {
        Object object;
        int n15 = imageInputStream.readUnsignedShort();
        short s15 = imageInputStream.readShort();
        int n16 = this.readValueCount(imageInputStream);
        if (n16 < 0) {
            throw new IIOException(String.format("Illegal count %d for tag %s type %s @%08x", n16, n15, s15, imageInputStream.getStreamPosition()));
        }
        if (!this.isValidType(s15)) {
            imageInputStream.skipBytes(4);
            if (DEBUG) {
                long l15 = imageInputStream.getStreamPosition() - 12L;
                System.err.printf("Bad TIFF data @%08x\n", imageInputStream.getStreamPosition());
                System.err.println("tagId: " + n15 + (n15 <= 0 ? " (INVALID)" : ""));
                System.err.println("type: " + s15 + " (INVALID)");
                System.err.println("count: " + n16);
                imageInputStream.mark();
                try {
                    imageInputStream.seek(l15);
                    byte[] byArray = new byte[8 + Math.min(120, Math.max(24, n16))];
                    int n17 = imageInputStream.read(byArray);
                    System.err.print(HexDump.dump(l15, byArray, 0, n17));
                    System.err.println(n17 < n16 ? "[...]" : "");
                }
                finally {
                    imageInputStream.reset();
                }
            }
            return null;
        }
        long l16 = TIFFEntry.getValueLength(s15, n16);
        if (l16 > 0L && l16 <= (long)this.offsetSize) {
            object = this.readValueInLine(imageInputStream, s15, n16);
            imageInputStream.skipBytes((long)this.offsetSize - l16);
        } else {
            long l17 = this.readOffset(imageInputStream);
            object = this.readValueAt(imageInputStream, l17, l16, s15, n16);
        }
        return new TIFFEntry(n15, s15, object);
    }

    private boolean isValidType(short s15) {
        return s15 > 0 && s15 < TIFF.TYPE_LENGTHS.length && TIFF.TYPE_LENGTHS[s15] > 0;
    }

    private int readValueCount(ImageInputStream imageInputStream) throws IOException {
        return this.assertIntCount(this.longOffsets ? imageInputStream.readLong() : imageInputStream.readUnsignedInt());
    }

    private int assertIntCount(long l15) throws IOException {
        if (l15 > Integer.MAX_VALUE) {
            throw new IIOException(String.format("Unsupported TIFF value count value: %s > Integer.MAX_VALUE", l15));
        }
        return (int)l15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidOffset(ImageInputStream imageInputStream, long l15) throws IOException {
        try {
            imageInputStream.mark();
            imageInputStream.seek(l15);
            boolean bl4 = imageInputStream.read() >= 0;
            return bl4;
        }
        catch (IOException iOException) {
            boolean bl5 = false;
            return bl5;
        }
        finally {
            imageInputStream.reset();
        }
    }

    private boolean isValidLengthAtOffset(ImageInputStream imageInputStream, long l15, long l16) throws IOException {
        return !(this.inputLength >= 0L && this.inputLength < l15 + l16 || l16 >= 32767L && !this.isValidOffset(imageInputStream, l15 + l16 - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readValueAt(ImageInputStream imageInputStream, long l15, long l16, short s15, int n15) throws IOException {
        long l17 = imageInputStream.getStreamPosition();
        try {
            imageInputStream.seek(l15);
            if (n15 < Integer.MAX_VALUE && this.isValidLengthAtOffset(imageInputStream, l15, l16)) {
                Object object = TIFFReader.readValue(imageInputStream, s15, n15, this.longOffsets);
                return object;
            }
            try {
                throw new EOFException(String.format("TIFF value offset or size too large: @%08x/%d bytes (input length: %s)", l15, l16, this.inputLength >= 0L ? this.inputLength + " bytes" : "unknown"));
            }
            catch (EOFException eOFException) {
                if (DEBUG) {
                    System.err.println(eOFException);
                }
                EOFException eOFException2 = eOFException;
                return eOFException2;
            }
        }
        finally {
            imageInputStream.seek(l17);
        }
    }

    private Object readValueInLine(ImageInputStream imageInputStream, short s15, int n15) throws IOException {
        return TIFFReader.readValue(imageInputStream, s15, n15, this.longOffsets);
    }

    private static Object readValue(ImageInputStream imageInputStream, short s15, int n15, boolean bl4) throws IOException {
        long l15 = imageInputStream.getStreamPosition();
        switch (s15) {
            case 2: {
                if (n15 == 0) {
                    return "";
                }
                byte[] byArray = new byte[n15];
                imageInputStream.readFully(byArray);
                int n16 = byArray[byArray.length - 1] == 0 ? byArray.length - 1 : byArray.length;
                String[] stringArray = new String(byArray, 0, n16, StandardCharsets.UTF_8).split("\u0000");
                return stringArray.length == 1 ? stringArray[0] : stringArray;
            }
            case 1: {
                if (n15 == 1) {
                    return imageInputStream.readUnsignedByte();
                }
            }
            case 6: {
                if (n15 == 1) {
                    return imageInputStream.readByte();
                }
            }
            case 7: {
                byte[] byArray = new byte[n15];
                imageInputStream.readFully(byArray);
                return byArray;
            }
            case 3: {
                if (n15 == 1) {
                    return imageInputStream.readUnsignedShort();
                }
            }
            case 8: {
                if (n15 == 1) {
                    return imageInputStream.readShort();
                }
                short[] sArray = new short[n15];
                imageInputStream.readFully(sArray, 0, sArray.length);
                if (s15 == 3) {
                    int[] nArray = new int[n15];
                    for (int i15 = 0; i15 < n15; ++i15) {
                        nArray[i15] = sArray[i15] & 0xFFFF;
                    }
                    return nArray;
                }
                return sArray;
            }
            case 4: 
            case 13: {
                if (n15 == 1) {
                    return imageInputStream.readUnsignedInt();
                }
            }
            case 9: {
                if (n15 == 1) {
                    return imageInputStream.readInt();
                }
                int[] nArray = new int[n15];
                imageInputStream.readFully(nArray, 0, nArray.length);
                if (s15 == 4 || s15 == 13) {
                    long[] lArray = new long[n15];
                    for (int i16 = 0; i16 < n15; ++i16) {
                        lArray[i16] = (long)nArray[i16] & 0xFFFFFFFFL;
                    }
                    return lArray;
                }
                return nArray;
            }
            case 11: {
                if (n15 == 1) {
                    return Float.valueOf(imageInputStream.readFloat());
                }
                float[] fArray = new float[n15];
                imageInputStream.readFully(fArray, 0, fArray.length);
                return fArray;
            }
            case 12: {
                if (n15 == 1) {
                    return imageInputStream.readDouble();
                }
                double[] dArray = new double[n15];
                imageInputStream.readFully(dArray, 0, dArray.length);
                return dArray;
            }
            case 5: {
                if (n15 == 1) {
                    return TIFFReader.createSafeRational(imageInputStream.readUnsignedInt(), imageInputStream.readUnsignedInt());
                }
                Rational[] rationalArray = new Rational[n15];
                for (int i17 = 0; i17 < rationalArray.length; ++i17) {
                    rationalArray[i17] = TIFFReader.createSafeRational(imageInputStream.readUnsignedInt(), imageInputStream.readUnsignedInt());
                }
                return rationalArray;
            }
            case 10: {
                if (n15 == 1) {
                    return TIFFReader.createSafeRational(imageInputStream.readInt(), imageInputStream.readInt());
                }
                Rational[] rationalArray = new Rational[n15];
                for (int i18 = 0; i18 < rationalArray.length; ++i18) {
                    rationalArray[i18] = TIFFReader.createSafeRational(imageInputStream.readInt(), imageInputStream.readInt());
                }
                return rationalArray;
            }
            case 16: 
            case 17: 
            case 18: {
                if (!bl4) break;
                if (n15 == 1) {
                    long l16 = imageInputStream.readLong();
                    if (s15 != 17 && l16 < 0L) {
                        throw new IIOException(String.format("Value > %s", Long.MAX_VALUE));
                    }
                    return l16;
                }
                long[] lArray = new long[n15];
                for (int i19 = 0; i19 < n15; ++i19) {
                    lArray[i19] = imageInputStream.readLong();
                }
                return lArray;
            }
        }
        return new Unknown(s15, n15, l15);
    }

    private static Rational createSafeRational(long l15, long l16) {
        if (l16 == 0L) {
            return Rational.NaN;
        }
        return new Rational(l15, l16);
    }

    public static void main(String[] stringArray) throws IOException {
        TIFFReader tIFFReader = new TIFFReader();
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(new File(stringArray[0]));){
            long l15 = 0L;
            if (stringArray.length > 1) {
                l15 = stringArray[1].startsWith("0x") ? (long)Integer.parseInt(stringArray[1].substring(2), 16) : Long.parseLong(stringArray[1]);
                imageInputStream.setByteOrder(l15 < 0L ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                l15 = Math.abs(l15);
                imageInputStream.seek(l15);
            }
            Directory directory = stringArray.length > 1 ? tIFFReader.readIFD(imageInputStream, l15, VALID_TOP_LEVEL_IFDS) : tIFFReader.read(imageInputStream);
            for (Entry entry : directory) {
                System.err.println(entry);
                Object object = entry.getValue();
                if (!(object instanceof byte[])) continue;
                byte[] byArray = (byte[])object;
                System.err.println(HexDump.dump(0L, byArray, 0, Math.min(byArray.length, 128)));
            }
        }
    }

    public static class HexDump {
        private static final int WIDTH = 32;

        private HexDump() {
        }

        public static String dump(byte[] byArray) {
            return HexDump.dump(0L, byArray, 0, byArray.length);
        }

        public static String dump(long l15, byte[] byArray, int n15, int n16) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i15 = 0; i15 < n16; ++i15) {
                if (i15 % 32 == 0) {
                    if (i15 > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(String.format("%08x: ", (long)(i15 + n15) + l15));
                } else if (i15 > 0 && i15 % 2 == 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(String.format("%02x", byArray[i15 + n15]));
                int n17 = i15 + 1;
                if (n17 % 32 != 0 && n17 != n16) continue;
                int n18 = (32 - n17 % 32) % 32;
                if (n18 != 0) {
                    int n19 = n18 / 2;
                    if (n16 % 2 != 0) {
                        stringBuilder.append("  ");
                    }
                    for (int i16 = 0; i16 < n19; ++i16) {
                        stringBuilder.append("     ");
                    }
                }
                stringBuilder.append("  ");
                stringBuilder.append(HexDump.toAsciiString(byArray, n17 - (32 - n18) + n15, n17 + n15));
            }
            return stringBuilder.toString();
        }

        private static String toAsciiString(byte[] byArray, int n15, int n16) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n15, n16);
            for (int i15 = 0; i15 < byArray2.length; ++i15) {
                if (byArray2[i15] >= 32 && byArray2[i15] <= 126) continue;
                byArray2[i15] = 46;
            }
            return new String(byArray2, StandardCharsets.US_ASCII);
        }
    }
}

