/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class FastByteArrayOutputStream
extends ByteArrayOutputStream {
    public FastByteArrayOutputStream(int n15) {
        super(n15);
    }

    public FastByteArrayOutputStream(byte[] byArray) {
        super(0);
        this.buf = byArray;
        this.count = byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n15, int n16) {
        if (n15 < 0 || n15 > byArray.length || n16 < 0 || n15 + n16 > byArray.length || n15 + n16 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n16 == 0) {
            return;
        }
        int n17 = this.count + n16;
        this.growIfNeeded(n17);
        System.arraycopy(byArray, n15, this.buf, this.count, n16);
        this.count = n17;
    }

    @Override
    public void write(int n15) {
        int n16 = this.count + 1;
        this.growIfNeeded(n16);
        this.buf[this.count] = (byte)n15;
        this.count = n16;
    }

    private void growIfNeeded(int n15) {
        if (n15 > this.buf.length) {
            int n16 = Math.max(this.buf.length << 1, n15);
            this.buf = Arrays.copyOf(this.buf, n16);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public ByteArrayInputStream createInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }
}

