/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.swing;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.awt.EventQueue;

final class SwingObserveOn<T>
extends Observable<T>
implements ObservableTransformer<T, T> {
    final Observable<T> source;

    SwingObserveOn(Observable<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new ObserveOnObserver<T>(observer));
    }

    @Override
    public ObservableSource<T> apply(Observable<T> upstream) {
        return new SwingObserveOn<T>(upstream);
    }

    static final class ObserveOnObserver<T>
    implements Observer<T>,
    Disposable,
    Runnable {
        final Observer<? super T> actual;
        Disposable upstream;
        volatile boolean disposed;

        ObserveOnObserver(Observer<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            EventQueue.invokeLater(new OnNextEvent<T>(this.actual, t15, this));
        }

        @Override
        public void onError(Throwable e15) {
            EventQueue.invokeLater(new OnErrorEvent<T>(this.actual, e15, this));
        }

        @Override
        public void onComplete() {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            if (!this.disposed) {
                this.actual.onComplete();
            }
        }

        static final class OnErrorEvent<T>
        implements Runnable {
            final Observer<? super T> actual;
            final Throwable event;
            final Disposable d;

            OnErrorEvent(Observer<? super T> actual, Throwable event, Disposable d15) {
                this.actual = actual;
                this.event = event;
                this.d = d15;
            }

            @Override
            public void run() {
                if (!this.d.isDisposed()) {
                    this.actual.onError(this.event);
                }
            }
        }

        static final class OnNextEvent<T>
        implements Runnable {
            final Observer<? super T> actual;
            final T event;
            final Disposable d;

            OnNextEvent(Observer<? super T> actual, T event, Disposable d15) {
                this.actual = actual;
                this.event = event;
                this.d = d15;
            }

            @Override
            public void run() {
                if (!this.d.isDisposed()) {
                    this.actual.onNext(this.event);
                }
            }
        }
    }
}

