/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableFromArray<T>
extends Flowable<T> {
    final T[] array;

    public FlowableFromArray(T[] array) {
        this.array = array;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            s15.onSubscribe(new ArrayConditionalSubscription<T>((ConditionalSubscriber)s15, this.array));
        } else {
            s15.onSubscribe(new ArraySubscription<T>(s15, this.array));
        }
    }

    static final class ArrayConditionalSubscription<T>
    extends BaseArraySubscription<T> {
        private static final long serialVersionUID = 2587302975077663557L;
        final ConditionalSubscriber<? super T> downstream;

        ArrayConditionalSubscription(ConditionalSubscriber<? super T> actual, T[] array) {
            super(array);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            Object[] arr = this.array;
            int f15 = arr.length;
            ConditionalSubscriber<Object> a15 = this.downstream;
            for (int i15 = this.index; i15 != f15; ++i15) {
                if (this.cancelled) {
                    return;
                }
                Object t15 = arr[i15];
                if (t15 == null) {
                    a15.onError(new NullPointerException("The element at index " + i15 + " is null"));
                    return;
                }
                a15.tryOnNext(t15);
            }
            if (this.cancelled) {
                return;
            }
            a15.onComplete();
        }

        @Override
        void slowPath(long r15) {
            long e15 = 0L;
            Object[] arr = this.array;
            int f15 = arr.length;
            int i15 = this.index;
            ConditionalSubscriber<Object> a15 = this.downstream;
            while (true) {
                if (e15 != r15 && i15 != f15) {
                    if (this.cancelled) {
                        return;
                    }
                    Object t15 = arr[i15];
                    if (t15 == null) {
                        a15.onError(new NullPointerException("The element at index " + i15 + " is null"));
                        return;
                    }
                    if (a15.tryOnNext(t15)) {
                        ++e15;
                    }
                    ++i15;
                    continue;
                }
                if (i15 == f15) {
                    if (!this.cancelled) {
                        a15.onComplete();
                    }
                    return;
                }
                r15 = this.get();
                if (e15 != r15) continue;
                this.index = i15;
                r15 = this.addAndGet(-e15);
                if (r15 == 0L) {
                    return;
                }
                e15 = 0L;
            }
        }
    }

    static final class ArraySubscription<T>
    extends BaseArraySubscription<T> {
        private static final long serialVersionUID = 2587302975077663557L;
        final Subscriber<? super T> downstream;

        ArraySubscription(Subscriber<? super T> actual, T[] array) {
            super(array);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            Object[] arr = this.array;
            int f15 = arr.length;
            Subscriber<Object> a15 = this.downstream;
            for (int i15 = this.index; i15 != f15; ++i15) {
                if (this.cancelled) {
                    return;
                }
                Object t15 = arr[i15];
                if (t15 == null) {
                    a15.onError(new NullPointerException("The element at index " + i15 + " is null"));
                    return;
                }
                a15.onNext(t15);
            }
            if (this.cancelled) {
                return;
            }
            a15.onComplete();
        }

        @Override
        void slowPath(long r15) {
            long e15 = 0L;
            Object[] arr = this.array;
            int f15 = arr.length;
            int i15 = this.index;
            Subscriber<Object> a15 = this.downstream;
            while (true) {
                if (e15 != r15 && i15 != f15) {
                    if (this.cancelled) {
                        return;
                    }
                    Object t15 = arr[i15];
                    if (t15 == null) {
                        a15.onError(new NullPointerException("The element at index " + i15 + " is null"));
                        return;
                    }
                    a15.onNext(t15);
                    ++e15;
                    ++i15;
                    continue;
                }
                if (i15 == f15) {
                    if (!this.cancelled) {
                        a15.onComplete();
                    }
                    return;
                }
                r15 = this.get();
                if (e15 != r15) continue;
                this.index = i15;
                r15 = this.addAndGet(-e15);
                if (r15 == 0L) {
                    return;
                }
                e15 = 0L;
            }
        }
    }

    static abstract class BaseArraySubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -2252972430506210021L;
        final T[] array;
        int index;
        volatile boolean cancelled;

        BaseArraySubscription(T[] array) {
            this.array = array;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @Nullable
        public final T poll() {
            int i15 = this.index;
            T[] arr = this.array;
            if (i15 == arr.length) {
                return null;
            }
            this.index = i15 + 1;
            return Objects.requireNonNull(arr[i15], "array element is null");
        }

        @Override
        public final boolean isEmpty() {
            return this.index == this.array.length;
        }

        @Override
        public final void clear() {
            this.index = this.array.length;
        }

        @Override
        public final void request(long n15) {
            if (SubscriptionHelper.validate(n15) && BackpressureHelper.add(this, n15) == 0L) {
                if (n15 == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n15);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

