/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.internal.fuseable.FuseToFlowable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSequenceEqual;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;

public final class FlowableSequenceEqualSingle<T>
extends Single<Boolean>
implements FuseToFlowable<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int prefetch;

    public FlowableSequenceEqualSingle(Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer, int prefetch) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(SingleObserver<? super Boolean> observer) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(observer, this.prefetch, this.comparer);
        observer.onSubscribe(parent);
        parent.subscribe(this.first, this.second);
    }

    @Override
    public Flowable<Boolean> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableSequenceEqual<T>(this.first, this.second, this.comparer, this.prefetch));
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable,
    FlowableSequenceEqual.EqualCoordinatorHelper {
        private static final long serialVersionUID = -6178010334400373240L;
        final SingleObserver<? super Boolean> downstream;
        final BiPredicate<? super T, ? super T> comparer;
        final FlowableSequenceEqual.EqualSubscriber<T> first;
        final FlowableSequenceEqual.EqualSubscriber<T> second;
        final AtomicThrowable errors;
        T v1;
        T v2;

        EqualCoordinator(SingleObserver<? super Boolean> actual, int prefetch, BiPredicate<? super T, ? super T> comparer) {
            this.downstream = actual;
            this.comparer = comparer;
            this.first = new FlowableSequenceEqual.EqualSubscriber(this, prefetch);
            this.second = new FlowableSequenceEqual.EqualSubscriber(this, prefetch);
            this.errors = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T> source1, Publisher<? extends T> source2) {
            source1.subscribe(this.first);
            source2.subscribe(this.second);
        }

        @Override
        public void dispose() {
            this.first.cancel();
            this.second.cancel();
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.first.clear();
                this.second.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.first.get() == SubscriptionHelper.CANCELLED;
        }

        void cancelAndClear() {
            this.first.cancel();
            this.first.clear();
            this.second.cancel();
            this.second.clear();
        }

        @Override
        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block6: do {
                Throwable ex4;
                SimpleQueue q15 = this.first.queue;
                SimpleQueue q25 = this.second.queue;
                if (q15 != null && q25 != null) {
                    while (true) {
                        boolean c15;
                        boolean e25;
                        if (this.isDisposed()) {
                            this.first.clear();
                            this.second.clear();
                            return;
                        }
                        ex4 = (Throwable)this.errors.get();
                        if (ex4 != null) {
                            this.cancelAndClear();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean d15 = this.first.done;
                        T a15 = this.v1;
                        if (a15 == null) {
                            try {
                                a15 = q15.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v1 = a15;
                        }
                        boolean e15 = a15 == null;
                        boolean d25 = this.second.done;
                        T b15 = this.v2;
                        if (b15 == null) {
                            try {
                                b15 = q25.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v2 = b15;
                        }
                        boolean bl4 = e25 = b15 == null;
                        if (d15 && d25 && e15 && e25) {
                            this.downstream.onSuccess((Boolean)true);
                            return;
                        }
                        if (d15 && d25 && e15 != e25) {
                            this.cancelAndClear();
                            this.downstream.onSuccess((Boolean)false);
                            return;
                        }
                        if (e15 || e25) continue block6;
                        try {
                            c15 = this.comparer.test(a15, b15);
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAndClear();
                            this.errors.tryAddThrowableOrReport(exc);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        if (!c15) {
                            this.cancelAndClear();
                            this.downstream.onSuccess((Boolean)false);
                            return;
                        }
                        this.v1 = null;
                        this.v2 = null;
                        this.first.request();
                        this.second.request();
                    }
                }
                if (this.isDisposed()) {
                    this.first.clear();
                    this.second.clear();
                    return;
                }
                ex4 = (Throwable)this.errors.get();
                if (ex4 == null) continue;
                this.cancelAndClear();
                this.errors.tryTerminateConsumer(this.downstream);
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        public void innerError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.drain();
            }
        }
    }
}

