/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableThrottleLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;
    final Consumer<? super T> onDropped;

    public FlowableThrottleLatest(Flowable<T> source, long timeout, TimeUnit unit, Scheduler scheduler, boolean emitLast, Consumer<? super T> onDropped) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new ThrottleLatestSubscriber<T>(s15, this.timeout, this.unit, this.scheduler.createWorker(), this.emitLast, this.onDropped));
    }

    static final class ThrottleLatestSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -8296689127439125014L;
        final Subscriber<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        final AtomicLong requested;
        final Consumer<? super T> onDropped;
        Subscription upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        long emitted;
        boolean timerRunning;

        ThrottleLatestSubscriber(Subscriber<? super T> downstream, long timeout, TimeUnit unit, Scheduler.Worker worker, boolean emitLast, Consumer<? super T> onDropped) {
            this.downstream = downstream;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
            this.requested = new AtomicLong();
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t15) {
            T old = this.latest.getAndSet(t15);
            if (this.onDropped != null && old != null) {
                try {
                    this.onDropped.accept(old);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.upstream.cancel();
                    this.error = ex4;
                    this.done = true;
                }
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.clear();
            }
        }

        void clear() {
            if (this.onDropped != null) {
                Object v15 = this.latest.getAndSet(null);
                if (v15 != null) {
                    try {
                        this.onDropped.accept(v15);
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        RxJavaPlugins.onError(ex4);
                    }
                }
            } else {
                this.latest.lazySet(null);
            }
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            AtomicLong requested = this.requested;
            Subscriber<T> downstream = this.downstream;
            while (true) {
                long e15;
                boolean empty;
                T v15;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                boolean d15 = this.done;
                Throwable error = this.error;
                if (d15 && error != null) {
                    if (this.onDropped != null) {
                        v15 = latest.getAndSet(null);
                        if (v15 != null) {
                            try {
                                this.onDropped.accept(v15);
                            }
                            catch (Throwable ex4) {
                                Exceptions.throwIfFatal(ex4);
                                error = new CompositeException(error, ex4);
                            }
                        }
                    } else {
                        latest.lazySet(null);
                    }
                    downstream.onError(error);
                    this.worker.dispose();
                    return;
                }
                v15 = latest.get();
                boolean bl4 = empty = v15 == null;
                if (d15) {
                    if (!empty) {
                        v15 = latest.getAndSet(null);
                        if (this.emitLast) {
                            e15 = this.emitted;
                            if (e15 != requested.get()) {
                                this.emitted = e15 + 1L;
                                downstream.onNext(v15);
                                downstream.onComplete();
                            } else {
                                this.tryDropAndSignalMBE(v15);
                            }
                        } else {
                            if (this.onDropped != null) {
                                try {
                                    this.onDropped.accept(v15);
                                }
                                catch (Throwable ex5) {
                                    Exceptions.throwIfFatal(ex5);
                                    downstream.onError(ex5);
                                    this.worker.dispose();
                                    return;
                                }
                            }
                            downstream.onComplete();
                        }
                    } else {
                        downstream.onComplete();
                    }
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v15 = latest.getAndSet(null);
                    e15 = this.emitted;
                    if (e15 == requested.get()) {
                        this.upstream.cancel();
                        this.tryDropAndSignalMBE(v15);
                        this.worker.dispose();
                        return;
                    }
                    downstream.onNext(v15);
                    this.emitted = e15 + 1L;
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.schedule(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void tryDropAndSignalMBE(T valueToDrop) {
            RuntimeException errorToSignal = MissingBackpressureException.createDefault();
            if (this.onDropped != null) {
                try {
                    this.onDropped.accept(valueToDrop);
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    errorToSignal = new CompositeException(errorToSignal, ex4);
                }
            }
            this.downstream.onError(errorToSignal);
        }
    }
}

