/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingObservableIterable<T>
implements Iterable<T> {
    final ObservableSource<? extends T> source;
    final int bufferSize;

    public BlockingObservableIterable(ObservableSource<? extends T> source, int bufferSize) {
        this.source = source;
        this.bufferSize = bufferSize;
    }

    @Override
    public Iterator<T> iterator() {
        BlockingObservableIterator it = new BlockingObservableIterator(this.bufferSize);
        this.source.subscribe(it);
        return it;
    }

    static final class BlockingObservableIterator<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Iterator<T>,
    Disposable {
        private static final long serialVersionUID = 6695226475494099826L;
        final SpscLinkedArrayQueue<T> queue;
        final Lock lock;
        final Condition condition;
        volatile boolean done;
        volatile Throwable error;

        BlockingObservableIterator(int batchSize) {
            this.queue = new SpscLinkedArrayQueue(batchSize);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            block5: while (true) {
                if (this.isDisposed()) {
                    Throwable e15 = this.error;
                    if (e15 != null) {
                        throw ExceptionHelper.wrapOrThrow(e15);
                    }
                    return false;
                }
                boolean d15 = this.done;
                boolean empty = this.queue.isEmpty();
                if (d15) {
                    Throwable e16 = this.error;
                    if (e16 != null) {
                        throw ExceptionHelper.wrapOrThrow(e16);
                    }
                    if (empty) {
                        return false;
                    }
                }
                if (!empty) break;
                try {
                    BlockingHelper.verifyNonBlocking();
                    this.lock.lock();
                    try {
                        while (true) {
                            if (this.done || !this.queue.isEmpty() || this.isDisposed()) continue block5;
                            this.condition.await();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                catch (InterruptedException ex4) {
                    DisposableHelper.dispose(this);
                    this.signalConsumer();
                    throw ExceptionHelper.wrapOrThrow(ex4);
                }
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.queue.poll();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onNext(T t15) {
            this.queue.offer(t15);
            this.signalConsumer();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.signalConsumer();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.signalConsumer();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }
    }
}

