/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.observers.SerializedObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableDebounce<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, ? extends ObservableSource<U>> debounceSelector;

    public ObservableDebounce(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<U>> debounceSelector) {
        super(source);
        this.debounceSelector = debounceSelector;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new DebounceObserver(new SerializedObserver<T>(t15), this.debounceSelector));
    }

    static final class DebounceObserver<T, U>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final Function<? super T, ? extends ObservableSource<U>> debounceSelector;
        Disposable upstream;
        final AtomicReference<Disposable> debouncer = new AtomicReference();
        volatile long index;
        boolean done;

        DebounceObserver(Observer<? super T> actual, Function<? super T, ? extends ObservableSource<U>> debounceSelector) {
            this.downstream = actual;
            this.debounceSelector = debounceSelector;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            ObservableSource<U> p15;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            Disposable d15 = this.debouncer.get();
            if (d15 != null) {
                d15.dispose();
            }
            try {
                p15 = Objects.requireNonNull(this.debounceSelector.apply(t15), "The ObservableSource supplied is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.dispose();
                this.downstream.onError(e15);
                return;
            }
            DebounceInnerObserver dis = new DebounceInnerObserver(this, idx, t15);
            if (this.debouncer.compareAndSet(d15, dis)) {
                p15.subscribe(dis);
            }
        }

        @Override
        public void onError(Throwable t15) {
            DisposableHelper.dispose(this.debouncer);
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Disposable d15 = this.debouncer.get();
            if (d15 != DisposableHelper.DISPOSED) {
                DebounceInnerObserver dis = (DebounceInnerObserver)d15;
                if (dis != null) {
                    dis.emit();
                }
                DisposableHelper.dispose(this.debouncer);
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            DisposableHelper.dispose(this.debouncer);
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void emit(long idx, T value) {
            if (idx == this.index) {
                this.downstream.onNext(value);
            }
        }

        static final class DebounceInnerObserver<T, U>
        extends DisposableObserver<U> {
            final DebounceObserver<T, U> parent;
            final long index;
            final T value;
            boolean done;
            final AtomicBoolean once = new AtomicBoolean();

            DebounceInnerObserver(DebounceObserver<T, U> parent, long index, T value) {
                this.parent = parent;
                this.index = index;
                this.value = value;
            }

            @Override
            public void onNext(U t15) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.dispose();
                this.emit();
            }

            void emit() {
                if (this.once.compareAndSet(false, true)) {
                    this.parent.emit(this.index, this.value);
                }
            }

            @Override
            public void onError(Throwable t15) {
                if (this.done) {
                    RxJavaPlugins.onError(t15);
                    return;
                }
                this.done = true;
                this.parent.onError(t15);
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.emit();
            }
        }
    }
}

