/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublishSelector<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super Observable<T>, ? extends ObservableSource<R>> selector;

    public ObservablePublishSelector(ObservableSource<T> source, Function<? super Observable<T>, ? extends ObservableSource<R>> selector) {
        super(source);
        this.selector = selector;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        ObservableSource<R> target;
        PublishSubject subject = PublishSubject.create();
        try {
            target = Objects.requireNonNull(this.selector.apply(subject), "The selector returned a null ObservableSource");
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptyDisposable.error(ex4, observer);
            return;
        }
        TargetObserver<? super R> o15 = new TargetObserver<R>(observer);
        target.subscribe(o15);
        this.source.subscribe(new SourceObserver(subject, o15));
    }

    static final class TargetObserver<R>
    extends AtomicReference<Disposable>
    implements Observer<R>,
    Disposable {
        private static final long serialVersionUID = 854110278590336484L;
        final Observer<? super R> downstream;
        Disposable upstream;

        TargetObserver(Observer<? super R> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void onError(Throwable e15) {
            DisposableHelper.dispose(this);
            this.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this);
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }

    static final class SourceObserver<T>
    implements Observer<T> {
        final PublishSubject<T> subject;
        final AtomicReference<Disposable> target;

        SourceObserver(PublishSubject<T> subject, AtomicReference<Disposable> target) {
            this.subject = subject;
            this.target = target;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this.target, d15);
        }

        @Override
        public void onNext(T value) {
            this.subject.onNext(value);
        }

        @Override
        public void onError(Throwable e15) {
            this.subject.onError(e15);
        }

        @Override
        public void onComplete() {
            this.subject.onComplete();
        }
    }
}

