/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class FutureSubscriber<T>
extends CountDownLatch
implements FlowableSubscriber<T>,
Future<T>,
Subscription {
    T value;
    Throwable error;
    final AtomicReference<Subscription> upstream = new AtomicReference();

    public FutureSubscriber() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription a15;
        do {
            if ((a15 = this.upstream.get()) != this && a15 != SubscriptionHelper.CANCELLED) continue;
            return false;
        } while (!this.upstream.compareAndSet(a15, SubscriptionHelper.CANCELLED));
        if (a15 != null) {
            a15.cancel();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.upstream.get() == SubscriptionHelper.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex4 = this.error;
        if (ex4 != null) {
            throw new ExecutionException(ex4);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException(ExceptionHelper.timeoutMessage(timeout, unit));
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex4 = this.error;
        if (ex4 != null) {
            throw new ExecutionException(ex4);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Subscription s15) {
        SubscriptionHelper.setOnce(this.upstream, s15, Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t15) {
        if (this.value != null) {
            this.upstream.get().cancel();
            this.onError(new IndexOutOfBoundsException("More than one element received"));
            return;
        }
        this.value = t15;
    }

    @Override
    public void onError(Throwable t15) {
        Subscription a15;
        if (this.error == null && (a15 = this.upstream.get()) != this && a15 != SubscriptionHelper.CANCELLED && this.upstream.compareAndSet(a15, this)) {
            this.error = t15;
            this.countDown();
            return;
        }
        RxJavaPlugins.onError(t15);
    }

    @Override
    public void onComplete() {
        if (this.value == null) {
            this.onError(new NoSuchElementException("The source is empty"));
            return;
        }
        Subscription a15 = this.upstream.get();
        if (a15 == this || a15 == SubscriptionHelper.CANCELLED) {
            return;
        }
        if (this.upstream.compareAndSet(a15, this)) {
            this.countDown();
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void request(long n15) {
    }
}

