/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.utils.FileSignature;
import jadx.core.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class FileTypeDetector {
    private static final Pattern DOCTYPE_PATTERN = Pattern.compile("\\s*<!doctype *(\\w+)[ >]", 2);
    private static final List<FileSignature> FILE_SIGNATURES = new ArrayList<FileSignature>();

    public static void register(String fileType, String signature) {
        FILE_SIGNATURES.add(new FileSignature(fileType, signature));
    }

    private static String detectByHeaders(byte[] data) {
        for (FileSignature sig : FILE_SIGNATURES) {
            if (!FileSignature.matches(sig, data)) continue;
            if (sig.getFileType().equals("png") && FileTypeDetector.isNinePatch(data)) {
                return ".9.png";
            }
            return "." + sig.getFileType();
        }
        return null;
    }

    public static String detectFileExtension(byte[] data) {
        String extByHeaders = FileTypeDetector.detectByHeaders(data);
        if (!StringUtils.isEmpty(extByHeaders)) {
            return extByHeaders;
        }
        String text = new String(data, StandardCharsets.UTF_8);
        if (text.startsWith("-----BEGIN CERTIFICATE-----")) {
            return ".cer";
        }
        if (text.startsWith("-----BEGIN PRIVATE KEY-----")) {
            return ".key";
        }
        if (text.contains("<html>")) {
            return ".html";
        }
        Matcher m15 = DOCTYPE_PATTERN.matcher(text);
        if (m15.lookingAt()) {
            return "." + m15.group(1).toLowerCase();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(data));
            String rootTag = doc.getDocumentElement().getNodeName();
            if ("svg".equalsIgnoreCase(rootTag)) {
                return ".svg";
            }
            if ("plist".equalsIgnoreCase(rootTag)) {
                return ".plist";
            }
            if ("kml".equalsIgnoreCase(rootTag)) {
                return ".kml";
            }
            return ".xml";
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int readInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    private static boolean isNinePatch(byte[] data) {
        int offset = 8;
        while (offset + 8 < data.length) {
            int chunkLength = FileTypeDetector.readInt(data, offset);
            int chunkType = FileTypeDetector.readInt(data, offset + 4);
            if (chunkType == 1852855395) {
                return true;
            }
            offset += 8 + chunkLength + 4;
        }
        return false;
    }

    static {
        FileTypeDetector.register("png", "89 50 4E 47");
        FileTypeDetector.register("jpg", "FF D8 FF");
        FileTypeDetector.register("gif", "47 49 46 38");
        FileTypeDetector.register("webp", "52 49 46 46 ?? ?? ?? ?? 57 45 42 50 56 50 38");
        FileTypeDetector.register("bmp", "42 4D");
        FileTypeDetector.register("bmp", "42 41");
        FileTypeDetector.register("bmp", "43 49");
        FileTypeDetector.register("bmp", "43 50");
        FileTypeDetector.register("bmp", "49 43");
        FileTypeDetector.register("bmp", "50 54");
        FileTypeDetector.register("mp4", "00 00 00 ?? 66 74 79 70 69 73 6F 36");
        FileTypeDetector.register("mp4", "00 00 00 ?? 66 74 79 70 6D 70 34 32");
        FileTypeDetector.register("m4a", "00 00 00 ?? 66 74 79 70 4D 34 41 20");
        FileTypeDetector.register("mp3", "49 44 33");
        FileTypeDetector.register("ogg", "4F 67 67 53");
        FileTypeDetector.register("wav", "52 49 46 46 ?? ?? ?? ?? 57 41 56 45");
        FileTypeDetector.register("ttf", "00 01 00 00");
        FileTypeDetector.register("ttc", "74 74 63 66");
        FileTypeDetector.register("otf", "4F 54 54 4F");
        FileTypeDetector.register("xml", "03 00 08 00");
    }
}

