/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.codegen.TypeGen;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.Nullable;

public final class LiteralArg
extends InsnArg {
    private final long literal;

    public static LiteralArg make(long value, ArgType type) {
        return new LiteralArg(value, type);
    }

    public static LiteralArg makeWithFixedType(long value, ArgType type) {
        return new LiteralArg(value, LiteralArg.fixLiteralType(value, type));
    }

    private static ArgType fixLiteralType(long value, ArgType type) {
        if (value == 0L || type.isTypeKnown() || type.contains(PrimitiveType.LONG) || type.contains(PrimitiveType.DOUBLE)) {
            return type;
        }
        if (value == 1L) {
            return ArgType.NARROW_NUMBERS;
        }
        if (value < 0L) {
            return ArgType.NARROW_NEG_NUMBERS;
        }
        return ArgType.NARROW_NUMBERS_NO_BOOL;
    }

    public static LiteralArg litFalse() {
        return new LiteralArg(0L, ArgType.BOOLEAN);
    }

    public static LiteralArg litTrue() {
        return new LiteralArg(1L, ArgType.BOOLEAN);
    }

    private LiteralArg(long value, ArgType type) {
        if (value != 0L && type.isObject()) {
            throw new JadxRuntimeException("Wrong literal type: " + String.valueOf(type) + " for value: " + value);
        }
        this.literal = value;
        this.type = type;
    }

    public long getLiteral() {
        return this.literal;
    }

    @Override
    public void setType(ArgType type) {
        super.setType(type);
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isZeroLiteral() {
        return this.literal == 0L;
    }

    public boolean isInteger() {
        switch (this.type.getPrimitiveType()) {
            case INT: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case LONG: {
                return true;
            }
        }
        return false;
    }

    public boolean isNegative() {
        if (this.isInteger()) {
            return this.literal < 0L;
        }
        if (this.type == ArgType.FLOAT) {
            float val = Float.intBitsToFloat((int)this.literal);
            return val < 0.0f && Float.isFinite(val);
        }
        if (this.type == ArgType.DOUBLE) {
            double val = Double.longBitsToDouble(this.literal);
            return val < 0.0 && Double.isFinite(val);
        }
        return false;
    }

    @Nullable
    public LiteralArg negate() {
        long neg;
        if (this.isInteger()) {
            neg = -this.literal;
        } else if (this.type == ArgType.FLOAT) {
            float val = Float.intBitsToFloat((int)this.literal);
            neg = Float.floatToIntBits(-val);
        } else if (this.type == ArgType.DOUBLE) {
            double val = Double.longBitsToDouble(this.literal);
            neg = Double.doubleToLongBits(-val);
        } else {
            return null;
        }
        return new LiteralArg(neg, this.type);
    }

    @Override
    public InsnArg duplicate() {
        return this.copyCommonParams(new LiteralArg(this.literal, this.type));
    }

    public int hashCode() {
        return (int)(this.literal ^ this.literal >>> 32) + 31 * this.getType().hashCode();
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        LiteralArg that = (LiteralArg)o15;
        return this.literal == that.literal && this.getType().equals(that.getType());
    }

    @Override
    public String toShortString() {
        return Long.toString(this.literal);
    }

    public String toString() {
        try {
            String value = TypeGen.literalToString(this.literal, this.getType(), StringUtils.getInstance(), true, false);
            if (this.getType().equals(ArgType.BOOLEAN) && (value.equals("true") || value.equals("false"))) {
                return value;
            }
            return "(" + value + " " + String.valueOf(this.type) + ")";
        }
        catch (JadxRuntimeException ex4) {
            return "(" + this.literal + " " + String.valueOf(this.type) + ")";
        }
    }
}

