/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.CodeFeaturesAttr;
import jadx.core.dex.attributes.nodes.RegionRefAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.IfRegionVisitor;
import jadx.core.dex.visitors.regions.LoopRegionVisitor;
import jadx.core.dex.visitors.regions.maker.SwitchRegionMaker;
import jadx.core.utils.BlockInsnPair;
import jadx.core.utils.BlockParentContainer;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ListUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="SwitchBreakVisitor", desc="Optimize 'break' instruction: common code extract, remove unreachable", runAfter={LoopRegionVisitor.class})
public class SwitchBreakVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (CodeFeaturesAttr.contains(mth, CodeFeaturesAttr.CodeFeature.SWITCH)) {
            SwitchBreakVisitor.runSwitchTraverse(mth, () -> new ExtractCommonBreak());
            SwitchBreakVisitor.runSwitchTraverse(mth, () -> new RemoveUnreachableBreak());
            IfRegionVisitor.processIfRequested(mth);
        }
    }

    private static void runSwitchTraverse(MethodNode mth, Supplier<BaseSwitchRegionVisitor> builder) {
        DepthRegionTraversal.traverse(mth, new IterativeSwitchRegionVisitor(builder));
    }

    @Override
    public String getName() {
        return "SwitchBreakVisitor";
    }

    private static final class IterativeSwitchRegionVisitor
    extends AbstractRegionVisitor {
        private final Supplier<BaseSwitchRegionVisitor> builder;

        public IterativeSwitchRegionVisitor(Supplier<BaseSwitchRegionVisitor> builder) {
            this.builder = builder;
        }

        @Override
        public void leaveRegion(MethodNode mth, IRegion region) {
            if (region instanceof SwitchRegion) {
                boolean runAgain;
                SwitchRegion switchRegion = (SwitchRegion)region;
                BaseSwitchRegionVisitor switchVisitor = this.builder.get();
                switchVisitor.setCurrentSwitch(switchRegion);
                int k15 = 0;
                do {
                    runAgain = false;
                    DepthRegionTraversal.traverse(mth, switchRegion, switchVisitor);
                    if (switchVisitor.isReRunRequested()) {
                        switchVisitor.reset();
                        runAgain = true;
                    }
                    if (k15++ <= 20) continue;
                    mth.addWarnComment("Unexpected iteration count in SwitchBreakVisitor. Please report as an issue");
                    break;
                } while (runAgain);
            }
        }
    }

    private static final class RemoveUnreachableBreak
    extends BaseSwitchRegionVisitor {
        private RemoveUnreachableBreak() {
        }

        @Override
        public void processRegion(MethodNode mth, IRegion region) {
            IBlock block;
            List<IContainer> subBlocks = region.getSubBlocks();
            IContainer lastContainer = ListUtils.last(subBlocks);
            if (lastContainer instanceof IBlock && this.isBreakBlock(block = (IBlock)lastContainer) && this.isPrevInsnIsExit(block, subBlocks)) {
                this.removeBreak(block, region);
            }
        }

        private boolean isPrevInsnIsExit(IBlock breakBlock, List<IContainer> subBlocks) {
            IContainer prev;
            InsnNode prevInsn = null;
            if (breakBlock.getInstructions().size() > 1) {
                List<InsnNode> insns = breakBlock.getInstructions();
                prevInsn = insns.get(insns.size() - 2);
            } else if (subBlocks.size() > 1 && (prev = subBlocks.get(subBlocks.size() - 2)) instanceof IBlock) {
                List<InsnNode> insns = ((IBlock)prev).getInstructions();
                prevInsn = ListUtils.last(insns);
            }
            return prevInsn != null && prevInsn.isExitEdgeInsn();
        }
    }

    private static final class ExtractCommonBreak
    extends BaseSwitchRegionVisitor {
        private ExtractCommonBreak() {
        }

        @Override
        public void processRegion(MethodNode mth, IRegion region) {
            if (region instanceof IBranchRegion && !(region instanceof SwitchRegion)) {
                this.processBranchRegion(mth, region);
            }
        }

        private void processBranchRegion(MethodNode mth, IRegion region) {
            IRegion parentRegion = region.getParent();
            if (parentRegion.contains(AFlag.FALL_THROUGH)) {
                return;
            }
            boolean dontAddCommonBreak = false;
            IBlock lastParentBlock = RegionUtils.getLastBlock(parentRegion);
            if (BlockUtils.containsExitInsn(lastParentBlock)) {
                if (this.isBreakBlock(lastParentBlock)) {
                    dontAddCommonBreak = true;
                } else {
                    return;
                }
            }
            List<IContainer> branches = ((IBranchRegion)region).getBranches();
            boolean removeCommonBreak = true;
            ArrayList<BlockParentContainer> forBreakRemove = new ArrayList<BlockParentContainer>();
            for (IContainer branch : branches) {
                if (branch == null) {
                    removeCommonBreak = false;
                    continue;
                }
                BlockInsnPair last = RegionUtils.getLastInsnWithBlock(branch);
                if (last == null) {
                    return;
                }
                InsnNode lastInsn = last.getInsn();
                if (lastInsn.getType() == InsnType.BREAK) {
                    IBlock block = last.getBlock();
                    IContainer parent = RegionUtils.getBlockContainer(branch, block);
                    forBreakRemove.add(new BlockParentContainer(parent, block));
                    removeCommonBreak = false;
                    continue;
                }
                if (lastInsn.isExitEdgeInsn()) continue;
                removeCommonBreak = false;
            }
            if (!forBreakRemove.isEmpty()) {
                for (BlockParentContainer breakData : forBreakRemove) {
                    this.removeBreak(breakData.getBlock(), breakData.getParent());
                }
                if (!dontAddCommonBreak) {
                    this.addBreakRegion.add(parentRegion);
                    this.requestReRun();
                }
                mth.add(AFlag.REQUEST_IF_REGION_OPTIMIZE);
            }
            if (removeCommonBreak && lastParentBlock != null) {
                this.removeBreak(lastParentBlock, parentRegion);
            }
        }
    }

    private static abstract class BaseSwitchRegionVisitor
    extends AbstractRegionVisitor {
        protected final Set<IRegion> addBreakRegion = new HashSet<IRegion>();
        protected final Set<IContainer> cleanupSet = new HashSet<IContainer>();
        protected SwitchRegion currentSwitch;
        private boolean reRunRequested = false;

        private BaseSwitchRegionVisitor() {
        }

        public abstract void processRegion(MethodNode var1, IRegion var2);

        @Override
        public boolean enterRegion(MethodNode mth, IRegion region) {
            this.processRegion(mth, region);
            return true;
        }

        @Override
        public void leaveRegion(MethodNode mth, IRegion region) {
            if (this.addBreakRegion.contains(region)) {
                this.addBreakRegion.remove(region);
                region.getSubBlocks().add(SwitchRegionMaker.buildBreakContainer(this.currentSwitch));
            }
            if (this.cleanupSet.contains(region)) {
                this.cleanupSet.remove(region);
                region.getSubBlocks().removeIf(r15 -> r15.contains(AFlag.REMOVE));
            }
        }

        public void reset() {
            this.reRunRequested = false;
            this.addBreakRegion.clear();
            this.cleanupSet.clear();
        }

        public void requestReRun() {
            this.reRunRequested = true;
        }

        public boolean isReRunRequested() {
            return this.reRunRequested;
        }

        public void setCurrentSwitch(SwitchRegion currentSwitch) {
            this.currentSwitch = currentSwitch;
        }

        protected boolean isBreakBlock(@Nullable IBlock block) {
            InsnNode lastInsn;
            if (block != null && (lastInsn = ListUtils.last(block.getInstructions())) != null && lastInsn.getType() == InsnType.BREAK) {
                RegionRefAttr regionRefAttr = lastInsn.get(AType.REGION_REF);
                return regionRefAttr != null && regionRefAttr.getRegion() == this.currentSwitch;
            }
            return false;
        }

        protected void removeBreak(IBlock breakBlock, IContainer parentContainer) {
            List<InsnNode> instructions = breakBlock.getInstructions();
            InsnNode last = ListUtils.last(instructions);
            if (last != null && last.getType() == InsnType.BREAK) {
                ListUtils.removeLast(instructions);
                if (instructions.isEmpty()) {
                    breakBlock.add(AFlag.REMOVE);
                    this.cleanupSet.add(parentContainer);
                }
            }
        }
    }
}

