/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.util.ArrayList;
import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class ACyclicDFACodeGenerator {
    protected CodeGenerator parentGenerator;

    public ACyclicDFACodeGenerator(CodeGenerator parent) {
        this.parentGenerator = parent;
    }

    public ST genFixedLookaheadDecision(STGroup templates, DFA dfa) {
        return this.walkFixedDFAGeneratingStateMachine(templates, dfa, dfa.startState, 1);
    }

    protected ST walkFixedDFAGeneratingStateMachine(STGroup templates, DFA dfa, DFAState s15, int k15) {
        ST targetST;
        ST edgeST;
        int i15;
        if (s15.isAcceptState()) {
            ST dfaST = templates.getInstanceOf("dfaAcceptState");
            dfaST.add("alt", Utils.integer(s15.getUniquelyPredictedAlt()));
            return dfaST;
        }
        String dfaStateName = "dfaState";
        String dfaLoopbackStateName = "dfaLoopbackState";
        String dfaOptionalBlockStateName = "dfaOptionalBlockState";
        String dfaEdgeName = "dfaEdge";
        if (this.parentGenerator.canGenerateSwitch(s15)) {
            dfaStateName = "dfaStateSwitch";
            dfaLoopbackStateName = "dfaLoopbackStateSwitch";
            dfaOptionalBlockStateName = "dfaOptionalBlockStateSwitch";
            dfaEdgeName = "dfaEdgeSwitch";
        }
        ST dfaST = templates.getInstanceOf(dfaStateName);
        if (dfa.getNFADecisionStartState().decisionStateType == 1) {
            dfaST = templates.getInstanceOf(dfaLoopbackStateName);
        } else if (dfa.getNFADecisionStartState().decisionStateType == 3) {
            dfaST = templates.getInstanceOf(dfaOptionalBlockStateName);
        }
        dfaST.add("k", Utils.integer(k15));
        dfaST.add("stateNumber", Utils.integer(s15.stateNumber));
        dfaST.add("semPredState", s15.isResolvedWithPredicates());
        int EOTPredicts = -1;
        DFAState EOTTarget = null;
        for (i15 = 0; i15 < s15.getNumberOfTransitions(); ++i15) {
            DFAState target;
            SemanticContext preds;
            Transition edge = s15.transition(i15);
            if (edge.label.getAtom() == -2) {
                EOTTarget = (DFAState)edge.target;
                EOTPredicts = EOTTarget.getUniquelyPredictedAlt();
                continue;
            }
            edgeST = templates.getInstanceOf(dfaEdgeName);
            if (edgeST.impl.formalArguments.get("labels") != null) {
                List<Integer> labels = edge.label.getSet().toList();
                ArrayList<String> targetLabels = new ArrayList<String>(labels.size());
                for (int j15 = 0; j15 < labels.size(); ++j15) {
                    Integer vI2 = labels.get(j15);
                    String label = this.parentGenerator.getTokenTypeAsTargetLabel(vI2);
                    targetLabels.add(label);
                }
                edgeST.add("labels", targetLabels);
            } else {
                edgeST.add("labelExpr", this.parentGenerator.genLabelExpr(templates, edge, k15));
            }
            if (!edge.label.isSemanticPredicate() && (preds = (target = (DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                ST predST = preds.genExpr(this.parentGenerator, this.parentGenerator.getTemplates(), dfa);
                edgeST.add("predicates", predST);
            }
            targetST = this.walkFixedDFAGeneratingStateMachine(templates, dfa, (DFAState)edge.target, k15 + 1);
            edgeST.add("targetState", targetST);
            dfaST.add("edges", edgeST);
        }
        if (EOTPredicts != -1) {
            dfaST.add("eotPredictsAlt", Utils.integer(EOTPredicts));
        } else if (EOTTarget != null && EOTTarget.getNumberOfTransitions() > 0) {
            for (i15 = 0; i15 < EOTTarget.getNumberOfTransitions(); ++i15) {
                Transition predEdge = EOTTarget.transition(i15);
                edgeST = templates.getInstanceOf(dfaEdgeName);
                edgeST.add("labelExpr", this.parentGenerator.genSemanticPredicateExpr(templates, predEdge));
                targetST = this.walkFixedDFAGeneratingStateMachine(templates, dfa, (DFAState)predEdge.target, k15 + 1);
                edgeST.add("targetState", targetST);
                dfaST.add("edges", edgeST);
            }
        }
        return dfaST;
    }
}

