/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import java.util.List;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;
import org.stringtemplate.v4.ST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    protected String[] targetCharValueEscape = new String[255];

    public Target() {
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
    }

    public boolean useBaseTemplatesForSynPredFragments() {
        return true;
    }

    protected void genRecognizerFile(Tool tool, CodeGenerator generator, Grammar grammar, ST outputFileST) throws IOException {
        String fileName = generator.getRecognizerFileName(grammar.name, grammar.type);
        generator.write(outputFileST, fileName);
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator generator, Grammar grammar, ST headerFileST, String extName) throws IOException {
    }

    protected void performGrammarAnalysis(CodeGenerator generator, Grammar grammar) {
        grammar.buildNFA();
        grammar.createLookaheadDFAs();
    }

    public boolean isValidActionScope(int grammarType, String scope) {
        switch (grammarType) {
            case 1: {
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 2: {
                if (!scope.equals("parser")) break;
                return true;
            }
            case 4: {
                if (scope.equals("parser")) {
                    return true;
                }
                if (!scope.equals("lexer")) break;
                return true;
            }
            case 3: {
                if (!scope.equals("treeparser")) break;
                return true;
            }
        }
        return false;
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        StringBuilder buf = new StringBuilder();
        buf.append('\'');
        int c15 = Grammar.getCharValueFromGrammarCharLiteral(literal);
        if (c15 < 0) {
            return "'\u0000'";
        }
        if (c15 < this.targetCharValueEscape.length && this.targetCharValueEscape[c15] != null) {
            buf.append(this.targetCharValueEscape[c15]);
        } else if (Character.UnicodeBlock.of((char)c15) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)c15)) {
            buf.append((char)c15);
        } else {
            String hex = Integer.toHexString(c15 | 0x10000).toUpperCase().substring(1, 5);
            buf.append("\\u");
            buf.append(hex);
        }
        buf.append('\'');
        return buf.toString();
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal) {
        StringBuilder sb5 = new StringBuilder();
        StringBuilder is4 = new StringBuilder(literal);
        sb5.append('\"');
        for (int i15 = 1; i15 < is4.length() - 1; ++i15) {
            if (is4.charAt(i15) == '\\') {
                switch (is4.charAt(i15 + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'u': {
                        sb5.append('\\');
                        break;
                    }
                }
                ++i15;
            } else if (is4.charAt(i15) == '\"') {
                sb5.append('\\');
            }
            sb5.append(is4.charAt(i15));
        }
        sb5.append('\"');
        return sb5.toString();
    }

    public String getTargetStringLiteralFromString(String s15, boolean quoted) {
        if (s15 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append('\"');
        }
        for (int i15 = 0; i15 < s15.length(); ++i15) {
            char c15 = s15.charAt(i15);
            if (c15 != '\'' && c15 < this.targetCharValueEscape.length && this.targetCharValueEscape[c15] != null) {
                buf.append(this.targetCharValueEscape[c15]);
                continue;
            }
            buf.append(c15);
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s15) {
        return this.getTargetStringLiteralFromString(s15, false);
    }

    public String getTarget64BitStringFromValue(long word) {
        int numHexDigits = 16;
        StringBuilder buf = new StringBuilder(numHexDigits + 2);
        buf.append("0x");
        String digits = Long.toHexString(word);
        digits = digits.toUpperCase();
        int padding = numHexDigits - digits.length();
        for (int i15 = 1; i15 <= padding; ++i15) {
            buf.append('0');
        }
        buf.append(digits);
        return buf.toString();
    }

    public String encodeIntAsCharEscape(int v15) {
        if (v15 <= 127) {
            return "\\" + Integer.toOctalString(v15);
        }
        String hex = Integer.toHexString(v15 | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    public int getMaxCharValue(CodeGenerator generator) {
        return 65535;
    }

    public List<Object> postProcessAction(List<Object> chunks, Token actionToken) {
        return chunks;
    }
}

