/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;

public class ComparableUtils {
    public static <A extends Comparable<A>> Predicate<A> between(A b15, A c15) {
        return a15 -> ComparableUtils.is(a15).between(b15, c15);
    }

    public static <A extends Comparable<A>> Predicate<A> betweenExclusive(A b15, A c15) {
        return a15 -> ComparableUtils.is(a15).betweenExclusive(b15, c15);
    }

    public static <A extends Comparable<A>> Predicate<A> ge(A b15) {
        return a15 -> ComparableUtils.is(a15).greaterThanOrEqualTo(b15);
    }

    public static <A extends Comparable<A>> Predicate<A> gt(A b15) {
        return a15 -> ComparableUtils.is(a15).greaterThan(b15);
    }

    public static <A extends Comparable<A>> ComparableCheckBuilder<A> is(A a15) {
        return new ComparableCheckBuilder(a15, null);
    }

    public static <A extends Comparable<A>> Predicate<A> le(A b15) {
        return a15 -> ComparableUtils.is(a15).lessThanOrEqualTo(b15);
    }

    public static <A extends Comparable<A>> Predicate<A> lt(A b15) {
        return a15 -> ComparableUtils.is(a15).lessThan(b15);
    }

    public static <A extends Comparable<A>> A max(A comparable1, A comparable2) {
        return ObjectUtils.compare(comparable1, comparable2, false) > 0 ? comparable1 : comparable2;
    }

    public static <A extends Comparable<A>> A min(A comparable1, A comparable2) {
        return ObjectUtils.compare(comparable1, comparable2, true) < 0 ? comparable1 : comparable2;
    }

    private ComparableUtils() {
    }

    public static class ComparableCheckBuilder<A extends Comparable<A>> {
        private final A a;

        private ComparableCheckBuilder(A a15) {
            this.a = a15;
        }

        public boolean between(A b15, A c15) {
            return this.betweenOrdered(b15, c15) || this.betweenOrdered(c15, b15);
        }

        public boolean betweenExclusive(A b15, A c15) {
            return this.betweenOrderedExclusive(b15, c15) || this.betweenOrderedExclusive(c15, b15);
        }

        private boolean betweenOrdered(A b15, A c15) {
            return this.greaterThanOrEqualTo(b15) && this.lessThanOrEqualTo(c15);
        }

        private boolean betweenOrderedExclusive(A b15, A c15) {
            return this.greaterThan(b15) && this.lessThan(c15);
        }

        public boolean equalTo(A b15) {
            return this.a != null && this.a.compareTo(b15) == 0;
        }

        public boolean greaterThan(A b15) {
            return this.a != null && this.a.compareTo(b15) > 0;
        }

        public boolean greaterThanOrEqualTo(A b15) {
            return this.a != null && this.a.compareTo(b15) >= 0;
        }

        public boolean lessThan(A b15) {
            return this.a != null && this.a.compareTo(b15) < 0;
        }

        public boolean lessThanOrEqualTo(A b15) {
            return this.a != null && this.a.compareTo(b15) <= 0;
        }

        /* synthetic */ ComparableCheckBuilder(Comparable x05, 1 x15) {
            this(x05);
        }
    }
}

